/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntry;
import org.hibernate.search.backend.lucene.document.impl.LuceneRootDocumentBuilder;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkOrchestrator;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.backend.index.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.index.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.index.spi.DocumentContributor;
import org.hibernate.search.engine.backend.index.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.index.spi.IndexDocumentWorkExecutor;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;

class LuceneIndexDocumentWorkExecutor
implements IndexDocumentWorkExecutor<LuceneRootDocumentBuilder> {
    private final LuceneWorkFactory factory;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final LuceneWriteWorkOrchestrator orchestrator;
    private final String indexName;
    private final String tenantId;
    private final DocumentCommitStrategy commitStrategy;

    LuceneIndexDocumentWorkExecutor(LuceneWorkFactory factory, MultiTenancyStrategy multiTenancyStrategy, LuceneWriteWorkOrchestrator orchestrator, String indexName, SessionContextImplementor sessionContext, DocumentCommitStrategy commitStrategy) {
        this.factory = factory;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.orchestrator = orchestrator;
        this.indexName = indexName;
        this.tenantId = sessionContext.getTenantIdentifier();
        this.commitStrategy = commitStrategy;
    }

    public CompletableFuture<?> add(DocumentReferenceProvider referenceProvider, DocumentContributor<LuceneRootDocumentBuilder> documentContributor) {
        String id = referenceProvider.getIdentifier();
        String routingKey = referenceProvider.getRoutingKey();
        LuceneRootDocumentBuilder builder = new LuceneRootDocumentBuilder();
        documentContributor.contribute((Object)builder);
        LuceneIndexEntry indexEntry = builder.build(this.indexName, this.multiTenancyStrategy, this.tenantId, id);
        return this.orchestrator.submit(this.factory.add(this.indexName, this.tenantId, id, routingKey, indexEntry), this.commitStrategy, DocumentRefreshStrategy.NONE);
    }
}

