/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.directory.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.SleepingLockWrapper;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.util.impl.AnalyzerConstants;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

class DirectoryHelper {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private DirectoryHelper() {
    }

    public static void initializeIndexIfNeeded(Directory directory, EventContext eventContext) throws IOException {
        if (DirectoryReader.indexExists((Directory)directory)) {
            return;
        }
        try {
            IndexWriterConfig iwriterConfig = new IndexWriterConfig(AnalyzerConstants.KEYWORD_ANALYZER).setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            SleepingLockWrapper delayedDirectory = new SleepingLockWrapper(directory, 2000L, 20L);
            IndexWriter iw = new IndexWriter((Directory)delayedDirectory, iwriterConfig);
            iw.close();
        }
        catch (LockObtainFailedException lofe) {
            log.lockingFailureDuringInitialization(directory.toString(), eventContext);
        }
    }

    public static void makeSanityCheckedFilesystemDirectory(Path indexDirectory, EventContext eventContext) {
        if (Files.exists(indexDirectory, new LinkOption[0])) {
            if (!Files.isDirectory(indexDirectory, new LinkOption[0]) || !Files.isWritable(indexDirectory)) {
                throw log.localDirectoryIndexRootDirectoryNotWritableDirectory(indexDirectory, eventContext);
            }
        } else {
            try {
                Files.createDirectories(indexDirectory, new FileAttribute[0]);
            }
            catch (Exception e) {
                throw log.unableToCreateIndexRootDirectoryForLocalDirectoryBackend(indexDirectory, eventContext, e);
            }
        }
    }
}

