/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.reader.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.hibernate.search.backend.lucene.index.spi.ReaderProvider;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.ManagedMultiReader;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class MultiReaderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private MultiReaderFactory() {
    }

    public static IndexReader openReader(Set<String> indexNames, Set<ReaderProvider> readerProviders) {
        if (readerProviders.isEmpty()) {
            return null;
        }
        try {
            return ManagedMultiReader.createInstance(readerProviders);
        }
        catch (IOException e) {
            throw log.ioExceptionOnMultiReaderRefresh(EventContexts.fromIndexNames(indexNames), e);
        }
    }

    public static void closeReader(IndexReader multiReader) {
        if (multiReader == null) {
            return;
        }
        try {
            multiReader.close();
        }
        catch (IOException e) {
            log.couldNotCloseResource(e);
        }
    }
}

