/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.writer.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.ThreadInterruptedException;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.engine.common.spi.ErrorHandler;
import org.hibernate.search.util.common.impl.SearchThreadFactory;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class HibernateSearchConcurrentMergeScheduler
extends ConcurrentMergeScheduler {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ErrorHandler errorHandler;
    private final String indexName;

    HibernateSearchConcurrentMergeScheduler(ErrorHandler errorHandler, String indexName) {
        this.errorHandler = errorHandler;
        this.indexName = indexName;
    }

    protected void handleMergeException(Directory dir, Throwable t) {
        try {
            super.handleMergeException(dir, t);
        }
        catch (ThreadInterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            this.errorHandler.handleException(log.exceptionDuringIndexMergeOperation(), (Throwable)ex);
        }
    }

    protected synchronized ConcurrentMergeScheduler.MergeThread getMergeThread(IndexWriter writer, MergePolicy.OneMerge merge) {
        ConcurrentMergeScheduler.MergeThread thread = new ConcurrentMergeScheduler.MergeThread((ConcurrentMergeScheduler)this, writer, merge);
        thread.setDaemon(true);
        thread.setName(SearchThreadFactory.createName((String)("Lucene Merge Thread for index " + this.indexName), (int)this.mergeThreadCount++));
        return thread;
    }
}

