/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.orchestration.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkOrchestratorImplementor;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkProcessor;
import org.hibernate.search.backend.lucene.work.impl.LuceneWriteWork;
import org.hibernate.search.engine.backend.index.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.index.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.orchestration.spi.AbstractWorkOrchestrator;
import org.hibernate.search.engine.backend.orchestration.spi.BatchingExecutor;

abstract class AbstractLuceneWriteWorkOrchestrator
extends AbstractWorkOrchestrator<LuceneWorkSet>
implements LuceneWriteWorkOrchestratorImplementor {
    AbstractLuceneWriteWorkOrchestrator(String name) {
        super(name);
    }

    @Override
    public CompletableFuture<?> submit(List<LuceneWriteWork<?>> works, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        this.submit(new LuceneMultipleWorkSet(works, future, commitStrategy, refreshStrategy));
        return future;
    }

    @Override
    public <T> CompletableFuture<T> submit(LuceneWriteWork<T> work, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        CompletableFuture future = new CompletableFuture();
        this.submit(new LuceneSingleWorkSet<T>(work, future, commitStrategy, refreshStrategy));
        return future;
    }

    static class LuceneSingleWorkSet<T>
    implements LuceneWorkSet {
        private final LuceneWriteWork<T> work;
        private final CompletableFuture<T> future;
        private final DocumentCommitStrategy commitStrategy;
        private final DocumentRefreshStrategy refreshStrategy;

        LuceneSingleWorkSet(LuceneWriteWork<T> work, CompletableFuture<T> future, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
            this.work = work;
            this.future = future;
            this.commitStrategy = commitStrategy;
            this.refreshStrategy = refreshStrategy;
        }

        public void submitTo(LuceneWriteWorkProcessor processor) {
            processor.beforeWorkSet(this.commitStrategy, this.refreshStrategy);
            T result = processor.submit(this.work);
            processor.afterWorkSet(this.future, result);
        }

        public void markAsFailed(Throwable t) {
            this.future.completeExceptionally(t);
        }
    }

    static class LuceneMultipleWorkSet
    implements LuceneWorkSet {
        private final List<LuceneWriteWork<?>> works;
        private final CompletableFuture<Object> future;
        private final DocumentCommitStrategy commitStrategy;
        private final DocumentRefreshStrategy refreshStrategy;

        LuceneMultipleWorkSet(List<LuceneWriteWork<?>> works, CompletableFuture<Object> future, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
            this.works = new ArrayList(works);
            this.future = future;
            this.commitStrategy = commitStrategy;
            this.refreshStrategy = refreshStrategy;
        }

        public void submitTo(LuceneWriteWorkProcessor processor) {
            processor.beforeWorkSet(this.commitStrategy, this.refreshStrategy);
            for (LuceneWriteWork<?> work : this.works) {
                processor.submit(work);
            }
            processor.afterWorkSet(this.future, null);
        }

        public void markAsFailed(Throwable t) {
            this.future.completeExceptionally(t);
        }
    }

    static interface LuceneWorkSet
    extends BatchingExecutor.WorkSet<LuceneWriteWorkProcessor> {
    }
}

