/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.orchestration.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.orchestration.impl.AbstractLuceneWriteWorkOrchestrator;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkOrchestratorImplementor;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneWriteWorkProcessor;
import org.hibernate.search.engine.backend.orchestration.spi.BatchingExecutor;
import org.hibernate.search.engine.common.spi.ErrorHandler;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneBatchingWriteWorkOrchestrator
extends AbstractLuceneWriteWorkOrchestrator
implements LuceneWriteWorkOrchestratorImplementor {
    private static final int MAX_WORKSETS_PER_BATCH = 1000;
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BatchingExecutor<AbstractLuceneWriteWorkOrchestrator.LuceneWorkSet, LuceneWriteWorkProcessor> executor;

    public LuceneBatchingWriteWorkOrchestrator(String name, LuceneWriteWorkProcessor processor, ErrorHandler errorHandler) {
        super(name);
        this.executor = new BatchingExecutor(name, (BatchingExecutor.WorkProcessor)processor, 1000, true, errorHandler);
    }

    @Override
    public void start() {
        this.executor.start();
    }

    protected void doSubmit(AbstractLuceneWriteWorkOrchestrator.LuceneWorkSet workSet) throws InterruptedException {
        this.executor.submit((BatchingExecutor.WorkSet)workSet);
    }

    protected void doClose() {
        try (Closer closer = new Closer();){
            closer.push(LuceneBatchingWriteWorkOrchestrator::awaitCompletionBeforeClose, (Object)this);
            closer.push(BatchingExecutor::stop, this.executor);
        }
    }

    private void awaitCompletionBeforeClose() {
        try {
            this.executor.awaitCompletion();
        }
        catch (InterruptedException e) {
            log.interruptedWhileWaitingForIndexActivity(this.getName(), e);
            Thread.currentThread().interrupt();
        }
    }
}

