/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.orchestration.impl;

import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.hibernate.search.backend.lucene.index.spi.ReaderProvider;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.MultiReaderFactory;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneReadWorkOrchestratorImplementor;
import org.hibernate.search.backend.lucene.work.impl.LuceneReadWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneReadWorkExecutionContext;
import org.hibernate.search.engine.backend.orchestration.spi.AbstractWorkOrchestrator;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneReadWorkOrchestratorImpl
extends AbstractWorkOrchestrator<ReadTask<?>>
implements LuceneReadWorkOrchestratorImplementor {
    public LuceneReadWorkOrchestratorImpl(String name) {
        super(name);
    }

    @Override
    public <T> T submit(Set<String> indexNames, Set<ReaderProvider> readerProviders, LuceneReadWork<T> work) {
        ReadTask<T> task = new ReadTask<T>(indexNames, readerProviders, work);
        Throwable throwable = null;
        try {
            this.submit(task);
            T t = task.getResult();
            return t;
        }
        catch (Throwable t) {
            throwable = t;
            throw t;
        }
        finally {
            if (throwable == null) {
                task.close();
            } else {
                new SuppressingCloser(throwable).push(task);
            }
        }
    }

    protected void doSubmit(ReadTask<?> task) {
        task.execute();
    }

    protected void doClose() {
    }

    static class ReadTask<T>
    implements AutoCloseable,
    LuceneReadWorkExecutionContext {
        private final Set<String> indexNames;
        private final IndexReader indexReader;
        private final LuceneReadWork<T> work;
        private T result;

        ReadTask(Set<String> indexNames, Set<ReaderProvider> readerProviders, LuceneReadWork<T> work) {
            this.indexNames = indexNames;
            this.indexReader = MultiReaderFactory.openReader(indexNames, readerProviders);
            this.work = work;
        }

        @Override
        public IndexReader getIndexReader() {
            return this.indexReader;
        }

        @Override
        public EventContext getEventContext() {
            return EventContexts.fromIndexNames(this.indexNames);
        }

        public void execute() {
            this.result = this.work.execute(this);
        }

        public T getResult() {
            return this.result;
        }

        @Override
        public void close() {
            MultiReaderFactory.closeReader(this.indexReader);
        }
    }
}

