/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.impl;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.backend.lucene.util.impl.LuceneFields;

public class LuceneQueries {
    private static final Query MAIN_DOCUMENT_QUERY = new TermQuery(new Term(LuceneFields.typeFieldName(), "main"));
    private static final Query CHILD_DOCUMENT_QUERY = new TermQuery(new Term(LuceneFields.typeFieldName(), "child"));

    private LuceneQueries() {
    }

    public static Query mainDocumentQuery() {
        return MAIN_DOCUMENT_QUERY;
    }

    public static Query childDocumentQuery() {
        return CHILD_DOCUMENT_QUERY;
    }

    public static Query nestedDocumentPathQuery(String absoluteFieldPath) {
        return new TermQuery(new Term(LuceneFields.nestedDocumentPathFieldName(), absoluteFieldPath));
    }

    public static Query discriminatorMultiTenancyDeleteDocumentQuery(String tenantId, String id) {
        return LuceneQueries.wrapWithDiscriminatorTenantIdQuery((Query)new TermQuery(new Term(LuceneFields.idFieldName(), id)), tenantId);
    }

    public static Query discriminatorMultiTenancyDeleteAllDocumentsQuery(String tenantId) {
        return new BooleanQuery.Builder().add((Query)new TermQuery(new Term(LuceneFields.tenantIdFieldName(), tenantId)), BooleanClause.Occur.FILTER).build();
    }

    public static Query wrapWithDiscriminatorTenantIdQuery(Query originalLuceneQuery, String tenantId) {
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        queryBuilder.add(originalLuceneQuery, BooleanClause.Occur.MUST);
        queryBuilder.add((Query)new TermQuery(new Term(LuceneFields.tenantIdFieldName(), tenantId)), BooleanClause.Occur.FILTER);
        return queryBuilder.build();
    }
}

