/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneReadWorkOrchestrator;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneDocumentStoredFieldVisitorBuilder;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchScopeModel;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryBuilder;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.mapper.mapping.context.spi.MappingContextImplementor;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.util.common.reporting.EventContext;

public class SearchBackendContext {
    private final EventContext eventContext;
    private final LuceneWorkFactory workFactory;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final LuceneReadWorkOrchestrator orchestrator;
    private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;

    public SearchBackendContext(EventContext eventContext, LuceneWorkFactory workFactory, MultiTenancyStrategy multiTenancyStrategy, LuceneReadWorkOrchestrator orchestrator, LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry) {
        this.eventContext = eventContext;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.workFactory = workFactory;
        this.orchestrator = orchestrator;
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.eventContext + "]";
    }

    public EventContext getEventContext() {
        return this.eventContext;
    }

    LuceneSearchContext createSearchContext(MappingContextImplementor mappingContext, LuceneSearchScopeModel scopeModel) {
        return new LuceneSearchContext(mappingContext, this.analysisDefinitionRegistry, this.multiTenancyStrategy, scopeModel);
    }

    <H> LuceneSearchQueryBuilder<H> createSearchQueryBuilder(LuceneSearchContext searchContext, SessionContextImplementor sessionContext, LoadingContextBuilder<?, ?> loadingContextBuilder, LuceneSearchProjection<?, H> rootProjection) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        LuceneDocumentStoredFieldVisitorBuilder storedFieldFilterBuilder = new LuceneDocumentStoredFieldVisitorBuilder();
        rootProjection.contributeFields(storedFieldFilterBuilder);
        return new LuceneSearchQueryBuilder<H>(this.workFactory, this.orchestrator, searchContext, sessionContext, storedFieldFilterBuilder.build(), loadingContextBuilder, rootProjection);
    }
}

