/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneNumericDomain;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneStandardFieldCodec;
import org.hibernate.search.backend.lucene.util.impl.LuceneFields;

public abstract class AbstractLuceneNumericFieldCodec<F, E extends Number>
implements LuceneStandardFieldCodec<F, E> {
    private final boolean projectable;
    private final boolean sortable;
    private final F indexNullAsValue;

    public AbstractLuceneNumericFieldCodec(boolean projectable, boolean sortable, F indexNullAsValue) {
        this.projectable = projectable;
        this.sortable = sortable;
        this.indexNullAsValue = indexNullAsValue;
    }

    @Override
    public final void encode(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, F value) {
        if (value == null && this.indexNullAsValue != null) {
            value = this.indexNullAsValue;
        }
        if (value == null) {
            return;
        }
        Number encodedValue = (Number)this.encode(value);
        if (this.projectable) {
            this.doEncodeForProjection(documentBuilder, absoluteFieldPath, value, encodedValue);
        }
        LuceneNumericDomain<Number> domain = this.getDomain();
        if (this.sortable) {
            documentBuilder.addField(domain.createDocValuesField(absoluteFieldPath, encodedValue));
        } else {
            documentBuilder.addFieldName(absoluteFieldPath);
        }
        documentBuilder.addField(domain.createIndexField(absoluteFieldPath, encodedValue));
    }

    @Override
    public Query createExistsQuery(String absoluteFieldPath) {
        if (this.sortable) {
            return new DocValuesFieldExistsQuery(absoluteFieldPath);
        }
        return new TermQuery(new Term(LuceneFields.fieldNamesFieldName(), absoluteFieldPath));
    }

    @Override
    public boolean isCompatibleWith(LuceneFieldCodec<?> obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractLuceneNumericFieldCodec other = (AbstractLuceneNumericFieldCodec)obj;
        return this.projectable == other.projectable && this.sortable == other.sortable;
    }

    public abstract LuceneNumericDomain<E> getDomain();

    abstract void doEncodeForProjection(LuceneDocumentBuilder var1, String var2, F var3, E var4);
}

