/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import org.apache.lucene.document.DoubleDocValuesField;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.FloatDocValuesField;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;

public abstract class LuceneNumericDomain<E> {
    public static final LuceneNumericDomain<Integer> INTEGER = new LuceneNumericDomain<Integer>(){

        @Override
        public Integer getMinValue() {
            return Integer.MIN_VALUE;
        }

        @Override
        public Integer getMaxValue() {
            return Integer.MAX_VALUE;
        }

        @Override
        public Integer getPreviousValue(Integer value) {
            return Math.addExact(value, -1);
        }

        @Override
        public Integer getNextValue(Integer value) {
            return Math.addExact(value, 1);
        }

        @Override
        public Query createExactQuery(String absoluteFieldPath, Integer value) {
            return IntPoint.newExactQuery((String)absoluteFieldPath, (int)value);
        }

        @Override
        public Query createRangeQuery(String absoluteFieldPath, Integer lowerLimit, Integer upperLimit) {
            return IntPoint.newRangeQuery((String)absoluteFieldPath, (int)lowerLimit, (int)upperLimit);
        }

        @Override
        public SortField.Type getSortFieldType() {
            return SortField.Type.INT;
        }

        @Override
        IndexableField createIndexField(String absoluteFieldPath, Integer numericValue) {
            return new IntPoint(absoluteFieldPath, new int[]{numericValue});
        }

        @Override
        IndexableField createDocValuesField(String absoluteFieldPath, Integer numericValue) {
            return new NumericDocValuesField(absoluteFieldPath, numericValue.longValue());
        }
    };
    public static final LuceneNumericDomain<Long> LONG = new LuceneNumericDomain<Long>(){

        @Override
        public Long getMinValue() {
            return Long.MIN_VALUE;
        }

        @Override
        public Long getMaxValue() {
            return Long.MAX_VALUE;
        }

        @Override
        public Long getPreviousValue(Long value) {
            return Math.addExact(value, -1L);
        }

        @Override
        public Long getNextValue(Long value) {
            return Math.addExact(value, 1L);
        }

        @Override
        public Query createExactQuery(String absoluteFieldPath, Long value) {
            return LongPoint.newExactQuery((String)absoluteFieldPath, (long)value);
        }

        @Override
        public Query createRangeQuery(String absoluteFieldPath, Long lowerLimit, Long upperLimit) {
            return LongPoint.newRangeQuery((String)absoluteFieldPath, (long)lowerLimit, (long)upperLimit);
        }

        @Override
        public SortField.Type getSortFieldType() {
            return SortField.Type.LONG;
        }

        @Override
        IndexableField createIndexField(String absoluteFieldPath, Long numericValue) {
            return new LongPoint(absoluteFieldPath, new long[]{numericValue});
        }

        @Override
        IndexableField createDocValuesField(String absoluteFieldPath, Long numericValue) {
            return new NumericDocValuesField(absoluteFieldPath, numericValue);
        }
    };
    public static final LuceneNumericDomain<Float> FLOAT = new LuceneNumericDomain<Float>(){

        @Override
        public Float getMinValue() {
            return Float.valueOf(Float.MIN_VALUE);
        }

        @Override
        public Float getMaxValue() {
            return Float.valueOf(Float.MAX_VALUE);
        }

        @Override
        public Float getPreviousValue(Float value) {
            return Float.valueOf(Math.nextDown(value.floatValue()));
        }

        @Override
        public Float getNextValue(Float value) {
            return Float.valueOf(Math.nextUp(value.floatValue()));
        }

        @Override
        public Query createExactQuery(String absoluteFieldPath, Float value) {
            return FloatPoint.newExactQuery((String)absoluteFieldPath, (float)value.floatValue());
        }

        @Override
        public Query createRangeQuery(String absoluteFieldPath, Float lowerLimit, Float upperLimit) {
            return FloatPoint.newRangeQuery((String)absoluteFieldPath, (float)lowerLimit.floatValue(), (float)upperLimit.floatValue());
        }

        @Override
        public SortField.Type getSortFieldType() {
            return SortField.Type.FLOAT;
        }

        @Override
        IndexableField createIndexField(String absoluteFieldPath, Float numericValue) {
            return new FloatPoint(absoluteFieldPath, new float[]{numericValue.floatValue()});
        }

        @Override
        IndexableField createDocValuesField(String absoluteFieldPath, Float numericValue) {
            return new FloatDocValuesField(absoluteFieldPath, numericValue.floatValue());
        }
    };
    public static final LuceneNumericDomain<Double> DOUBLE = new LuceneNumericDomain<Double>(){

        @Override
        public Double getMinValue() {
            return Double.MIN_VALUE;
        }

        @Override
        public Double getMaxValue() {
            return Double.MAX_VALUE;
        }

        @Override
        public Double getPreviousValue(Double value) {
            return Math.nextDown(value);
        }

        @Override
        public Double getNextValue(Double value) {
            return Math.nextUp(value);
        }

        @Override
        public Query createExactQuery(String absoluteFieldPath, Double value) {
            return DoublePoint.newExactQuery((String)absoluteFieldPath, (double)value);
        }

        @Override
        public Query createRangeQuery(String absoluteFieldPath, Double lowerLimit, Double upperLimit) {
            return DoublePoint.newRangeQuery((String)absoluteFieldPath, (double)lowerLimit, (double)upperLimit);
        }

        @Override
        public SortField.Type getSortFieldType() {
            return SortField.Type.DOUBLE;
        }

        @Override
        IndexableField createIndexField(String absoluteFieldPath, Double numericValue) {
            return new DoublePoint(absoluteFieldPath, new double[]{numericValue});
        }

        @Override
        IndexableField createDocValuesField(String absoluteFieldPath, Double numericValue) {
            return new DoubleDocValuesField(absoluteFieldPath, numericValue.doubleValue());
        }
    };

    public abstract E getMinValue();

    public abstract E getMaxValue();

    public abstract E getPreviousValue(E var1);

    public abstract E getNextValue(E var1);

    public abstract Query createExactQuery(String var1, E var2);

    public abstract Query createRangeQuery(String var1, E var2, E var3);

    public abstract SortField.Type getSortFieldType();

    abstract IndexableField createIndexField(String var1, E var2);

    abstract IndexableField createDocValuesField(String var1, E var2);
}

