/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.time.Instant;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneInstantFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeContext;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneNumericFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class LuceneInstantIndexFieldTypeContext
extends AbstractLuceneStandardIndexFieldTypeContext<LuceneInstantIndexFieldTypeContext, Instant> {
    private Sortable sortable = Sortable.DEFAULT;

    LuceneInstantIndexFieldTypeContext(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, Instant.class);
    }

    public LuceneInstantIndexFieldTypeContext sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexFieldType<Instant> toIndexFieldType() {
        boolean resolvedSortable = LuceneInstantIndexFieldTypeContext.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneInstantIndexFieldTypeContext.resolveDefault(this.projectable);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        LuceneInstantFieldCodec codec = new LuceneInstantFieldCodec(resolvedProjectable, resolvedSortable, (Instant)this.indexNullAsValue);
        return new LuceneIndexFieldType<Instant>(codec, new LuceneNumericFieldPredicateBuilderFactory<Instant, Long>((ToDocumentFieldValueConverter<?, Instant>)dslToIndexConverter, (ToDocumentFieldValueConverter<Instant, Instant>)this.createToDocumentRawConverter(), codec), new LuceneNumericFieldSortBuilderFactory<Instant, Long>(resolvedSortable, (ToDocumentFieldValueConverter<?, Instant>)dslToIndexConverter, (ToDocumentFieldValueConverter<Instant, Instant>)this.createToDocumentRawConverter(), codec), new LuceneStandardFieldProjectionBuilderFactory<Instant>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec));
    }

    @Override
    protected LuceneInstantIndexFieldTypeContext thisAsS() {
        return this;
    }
}

