/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.QueryBuilder;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.impl.LuceneCompatibilityChecker;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateContext;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneTextFieldCodec;
import org.hibernate.search.backend.lucene.util.impl.AnalyzerConstants;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.predicate.spi.PhrasePredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class LuceneTextPhrasePredicateBuilder
extends AbstractLuceneSearchPredicateBuilder
implements PhrasePredicateBuilder<LuceneSearchPredicateBuilder> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final String absoluteFieldPath;
    protected final LuceneTextFieldCodec<?> codec;
    private final LuceneCompatibilityChecker analyzerChecker;
    private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private int slop;
    private String phrase;
    private Analyzer analyzer;
    private boolean analyzerOverridden = false;

    LuceneTextPhrasePredicateBuilder(LuceneSearchContext searchContext, String absoluteFieldPath, LuceneTextFieldCodec<?> codec, Analyzer analyzerOrNormalizer, LuceneCompatibilityChecker analyzerChecker) {
        this.absoluteFieldPath = absoluteFieldPath;
        this.codec = codec;
        this.analyzer = analyzerOrNormalizer;
        this.analyzerChecker = analyzerChecker;
        this.analysisDefinitionRegistry = searchContext.getAnalysisDefinitionRegistry();
    }

    public void slop(int slop) {
        this.slop = slop;
    }

    public void phrase(String phrase) {
        this.phrase = phrase;
    }

    public void analyzer(String analyzerName) {
        this.analyzer = this.analysisDefinitionRegistry.getAnalyzerDefinition(analyzerName);
        if (this.analyzer == null) {
            throw log.unknownAnalyzer(analyzerName, EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }
        this.analyzerOverridden = true;
    }

    public void skipAnalysis() {
        this.analyzer = AnalyzerConstants.KEYWORD_ANALYZER;
        this.analyzerOverridden = true;
    }

    @Override
    protected Query doBuild(LuceneSearchPredicateContext context) {
        if (!this.analyzerOverridden) {
            this.analyzerChecker.failIfNotCompatible();
        }
        if (this.analyzer != null) {
            Query analyzed = new QueryBuilder(this.analyzer).createPhraseQuery(this.absoluteFieldPath, this.phrase, this.slop);
            if (analyzed == null) {
                analyzed = new MatchNoDocsQuery("No tokens after analysis of the phrase to match");
            }
            return analyzed;
        }
        return new TermQuery(new Term(this.absoluteFieldPath, this.codec.normalize(this.absoluteFieldPath, this.phrase)));
    }
}

