/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.sort.impl;

import org.apache.lucene.search.SortField;
import org.hibernate.search.backend.lucene.search.impl.LuceneCompatibilityChecker;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortCollector;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneTextFieldCodec;
import org.hibernate.search.backend.lucene.types.sort.impl.AbstractLuceneStandardFieldSortBuilder;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.search.dsl.sort.SortOrder;

public class LuceneTextFieldSortBuilder<F>
extends AbstractLuceneStandardFieldSortBuilder<F, String, LuceneTextFieldCodec<F>> {
    LuceneTextFieldSortBuilder(LuceneSearchContext searchContext, String absoluteFieldPath, ToDocumentFieldValueConverter<?, ? extends F> converter, ToDocumentFieldValueConverter<F, ? extends F> rawConverter, LuceneCompatibilityChecker converterChecker, LuceneTextFieldCodec<F> codec) {
        super(searchContext, absoluteFieldPath, converter, rawConverter, converterChecker, codec, SortField.STRING_FIRST, SortField.STRING_LAST);
    }

    @Override
    protected Object encodeMissingAs(F converted) {
        return ((LuceneTextFieldCodec)this.codec).normalize(this.absoluteFieldPath, (String)((LuceneTextFieldCodec)this.codec).encode(converted)).utf8ToString();
    }

    @Override
    public void buildAndContribute(LuceneSearchSortCollector collector) {
        SortField sortField = new SortField(this.absoluteFieldPath, SortField.Type.STRING, this.order == SortOrder.DESC);
        this.setEffectiveMissingValue(sortField, this.missingValue, this.order);
        collector.collectSortField(sortField);
    }
}

