/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.util.impl;

import java.util.Collections;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.simple.SimpleQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;

public class FieldContextSimpleQueryParser
extends SimpleQueryParser {
    private final Map<String, ? extends FieldContext> fieldContexts;

    public FieldContextSimpleQueryParser(Analyzer analyzer, Map<String, ? extends FieldContext> fieldContexts) {
        this(analyzer, fieldContexts, -1);
    }

    public FieldContextSimpleQueryParser(Analyzer analyzer, Map<String, ? extends FieldContext> fieldContexts, int flags) {
        super(analyzer, Collections.emptyMap(), flags);
        this.fieldContexts = fieldContexts;
    }

    protected Query newDefaultQuery(String text) {
        BooleanQuery.Builder bqb = new BooleanQuery.Builder();
        for (Map.Entry<String, ? extends FieldContext> entry : this.fieldContexts.entrySet()) {
            Query q = this.createBooleanQuery(entry.getKey(), text, this.getDefaultOperator());
            if (q == null) continue;
            bqb.add(entry.getValue().wrap(q), BooleanClause.Occur.SHOULD);
        }
        return this.simplify(bqb.build());
    }

    protected Query newFuzzyQuery(String text, int fuzziness) {
        BooleanQuery.Builder bqb = new BooleanQuery.Builder();
        for (Map.Entry<String, ? extends FieldContext> entry : this.fieldContexts.entrySet()) {
            FuzzyQuery q = new FuzzyQuery(new Term(entry.getKey(), text), fuzziness);
            bqb.add(entry.getValue().wrap((Query)q), BooleanClause.Occur.SHOULD);
        }
        return this.simplify(bqb.build());
    }

    protected Query newPhraseQuery(String text, int slop) {
        BooleanQuery.Builder bqb = new BooleanQuery.Builder();
        for (Map.Entry<String, ? extends FieldContext> entry : this.fieldContexts.entrySet()) {
            Query q = this.createPhraseQuery(entry.getKey(), text, slop);
            if (q == null) continue;
            bqb.add(entry.getValue().wrap(q), BooleanClause.Occur.SHOULD);
        }
        return this.simplify(bqb.build());
    }

    protected Query newPrefixQuery(String text) {
        BooleanQuery.Builder bqb = new BooleanQuery.Builder();
        for (Map.Entry<String, ? extends FieldContext> entry : this.fieldContexts.entrySet()) {
            PrefixQuery prefix = new PrefixQuery(new Term(entry.getKey(), text));
            bqb.add(entry.getValue().wrap((Query)prefix), BooleanClause.Occur.SHOULD);
        }
        return this.simplify(bqb.build());
    }

    public static interface FieldContext {
        public Query wrap(Query var1);
    }
}

