/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterDelegator;
import org.hibernate.search.backend.lucene.work.impl.AbstractLuceneWriteWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneWriteWorkExecutionContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractLuceneDeleteAllEntriesWork
extends AbstractLuceneWriteWork<Long> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String tenantId;

    public AbstractLuceneDeleteAllEntriesWork(String indexName, String tenantId) {
        super("deleteAllEntries", indexName);
        this.tenantId = tenantId;
    }

    @Override
    public Long execute(LuceneWriteWorkExecutionContext context) {
        try {
            IndexWriterDelegator indexWriterDelegator = context.getIndexWriterDelegator();
            return this.doDeleteDocuments(indexWriterDelegator, this.tenantId);
        }
        catch (IOException e) {
            throw log.unableToDeleteAllEntriesFromIndex(this.tenantId, this.getEventContext(), e);
        }
    }

    protected abstract long doDeleteDocuments(IndexWriterDelegator var1, String var2) throws IOException;

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("type=").append(this.workType).append(", indexName=").append(this.indexName).append("]");
        return sb.toString();
    }
}

