/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.impl;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.AbstractLuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectFieldNode;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class LuceneFlattenedObjectDocumentBuilder
extends AbstractLuceneDocumentBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final AbstractLuceneDocumentBuilder parent;
    private final Set<String> encounteredFields = new HashSet<String>();

    LuceneFlattenedObjectDocumentBuilder(LuceneIndexModel model, LuceneIndexSchemaObjectFieldNode schemaNode, AbstractLuceneDocumentBuilder parent) {
        super(model, schemaNode);
        this.parent = parent;
    }

    @Override
    public void addField(IndexableField field) {
        this.parent.addField(field);
    }

    @Override
    public void addFieldName(String absoluteFieldPath) {
        this.parent.addFieldName(absoluteFieldPath);
    }

    @Override
    void checkNoValueYetForSingleValued(String absoluteFieldPath) {
        boolean firstEncounter = this.encounteredFields.add(absoluteFieldPath);
        if (!firstEncounter) {
            throw log.multipleValuesForSingleValuedField(absoluteFieldPath);
        }
    }
}

