/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexObjectFieldReference;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.AbstractLuceneIndexSchemaObjectNodeBuilder;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexSchemaRootNodeBuilder;
import org.hibernate.search.backend.lucene.document.model.impl.AbstractLuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaNodeCollector;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaNodeContributor;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectFieldNodeBuilder;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.backend.types.ObjectStructure;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

class LuceneIndexSchemaObjectFieldNodeBuilder
extends AbstractLuceneIndexSchemaObjectNodeBuilder
implements IndexSchemaObjectFieldNodeBuilder,
LuceneIndexSchemaNodeContributor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final AbstractLuceneIndexSchemaObjectNodeBuilder parent;
    private final String absoluteFieldPath;
    private final String relativeFieldName;
    private final IndexFieldInclusion inclusion;
    private final ObjectStructure structure;
    private boolean multiValued = false;
    private LuceneIndexObjectFieldReference reference;

    LuceneIndexSchemaObjectFieldNodeBuilder(AbstractLuceneIndexSchemaObjectNodeBuilder parent, String relativeFieldName, IndexFieldInclusion inclusion, ObjectStructure structure) {
        this.parent = parent;
        this.absoluteFieldPath = FieldPaths.compose((String)parent.getAbsolutePath(), (String)relativeFieldName);
        this.relativeFieldName = relativeFieldName;
        this.inclusion = inclusion;
        this.structure = structure;
    }

    public EventContext eventContext() {
        return this.getRootNodeBuilder().getIndexEventContext().append(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
    }

    public void multiValued() {
        this.multiValued = true;
    }

    public IndexObjectFieldReference toReference() {
        if (this.reference != null) {
            throw log.cannotCreateReferenceMultipleTimes(this.eventContext());
        }
        this.reference = new LuceneIndexObjectFieldReference();
        return this.reference;
    }

    @Override
    public void contribute(LuceneIndexSchemaNodeCollector collector, LuceneIndexSchemaObjectNode parentNode, List<AbstractLuceneIndexSchemaFieldNode> staticChildrenForParent) {
        if (this.reference == null) {
            throw log.incompleteFieldDefinition(this.eventContext());
        }
        ArrayList<AbstractLuceneIndexSchemaFieldNode> staticChildren = new ArrayList<AbstractLuceneIndexSchemaFieldNode>();
        LuceneIndexSchemaObjectFieldNode node = new LuceneIndexSchemaObjectFieldNode(parentNode, this.relativeFieldName, this.inclusion, this.structure, this.multiValued, staticChildren);
        staticChildrenForParent.add(node);
        collector.collectObjectFieldNode(this.absoluteFieldPath, node);
        this.reference.setSchemaNode(node);
        this.contributeChildren(node, collector, staticChildren);
    }

    @Override
    public LuceneIndexSchemaRootNodeBuilder getRootNodeBuilder() {
        return this.parent.getRootNodeBuilder();
    }

    @Override
    String getAbsolutePath() {
        return this.absoluteFieldPath;
    }
}

