/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.index.impl;

import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryHolder;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.IOStrategy;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderProvider;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.NearRealTimeIndexReaderProvider;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterConfigSource;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterProvider;
import org.hibernate.search.backend.lucene.resources.impl.BackendThreads;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.common.timing.spi.TimingSource;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.util.common.reporting.EventContext;

public class NearRealTimeIOStrategy
extends IOStrategy {
    private static final ConfigurationProperty<Integer> COMMIT_INTERVAL = ConfigurationProperty.forKey((String)"io.commit_interval").asInteger().withDefault((Object)1000).build();
    private static final ConfigurationProperty<Integer> REFRESH_INTERVAL = ConfigurationProperty.forKey((String)"io.refresh_interval").asInteger().withDefault((Object)0).build();
    private final TimingSource timingSource;
    private final int commitInterval;
    private final int refreshInterval;

    public static NearRealTimeIOStrategy create(ConfigurationPropertySource propertySource, TimingSource timingSource, BackendThreads threads, FailureHandler failureHandler) {
        int commitInterval = (Integer)COMMIT_INTERVAL.get(propertySource);
        int refreshInterval = (Integer)REFRESH_INTERVAL.get(propertySource);
        return new NearRealTimeIOStrategy(timingSource, commitInterval, refreshInterval, threads, failureHandler);
    }

    private NearRealTimeIOStrategy(TimingSource timingSource, int commitInterval, int refreshInterval, BackendThreads threads, FailureHandler failureHandler) {
        super(threads, failureHandler);
        this.timingSource = timingSource;
        this.commitInterval = commitInterval;
        this.refreshInterval = refreshInterval;
    }

    @Override
    IndexWriterProvider createIndexWriterProvider(String indexName, EventContext eventContext, DirectoryHolder directoryHolder, IndexWriterConfigSource configSource) {
        if (this.commitInterval != 0) {
            this.timingSource.ensureInitialized();
        }
        return new IndexWriterProvider(indexName, eventContext, directoryHolder, configSource, this.timingSource, this.commitInterval, this.threads, this.failureHandler);
    }

    @Override
    IndexReaderProvider createIndexReaderProvider(DirectoryHolder directoryHolder, IndexWriterProvider indexWriterProvider) {
        if (this.refreshInterval != 0) {
            this.timingSource.ensureInitialized();
        }
        return new NearRealTimeIndexReaderProvider(indexWriterProvider, this.timingSource, this.refreshInterval);
    }
}

