/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.query.impl;

import java.util.Arrays;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.ExplicitDocIdSetIterator;

public final class ExplicitDocIdsQuery
extends Query {
    private final int[] sortedDocIds;

    public ExplicitDocIdsQuery(ScoreDoc[] scoreDocs, int start, int end) {
        int size = end - start;
        int[] docIds = new int[size];
        for (int i = 0; i < size; ++i) {
            docIds[i] = scoreDocs[start + i].doc;
        }
        Arrays.sort(docIds);
        this.sortedDocIds = docIds;
    }

    public String toString(String field) {
        return ((Object)((Object)this)).getClass().getName() + "{" + Arrays.toString(this.sortedDocIds) + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ExplicitDocIdsQuery other = (ExplicitDocIdsQuery)((Object)obj);
        return Arrays.equals(this.sortedDocIds, other.sortedDocIds);
    }

    public int hashCode() {
        return Arrays.hashCode(this.sortedDocIds);
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) {
        return new ConstantScoreWeight(this, 1.0f){

            public Scorer scorer(LeafReaderContext context) {
                DocIdSetIterator matchingDocs = ExplicitDocIdSetIterator.of(ExplicitDocIdsQuery.this.sortedDocIds, context.docBase, context.reader().maxDoc());
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, matchingDocs);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }
        };
    }
}

