/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.schema.management.impl;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneParallelWorkOrchestrator;
import org.hibernate.search.backend.lucene.schema.management.impl.SchemaManagementIndexManagerContext;
import org.hibernate.search.backend.lucene.work.impl.IndexManagementWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.backend.schema.management.spi.IndexSchemaManager;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;

public class LuceneIndexSchemaManager
implements IndexSchemaManager {
    private final LuceneWorkFactory luceneWorkFactory;
    private final SchemaManagementIndexManagerContext indexManagerContext;

    public LuceneIndexSchemaManager(LuceneWorkFactory luceneWorkFactory, SchemaManagementIndexManagerContext indexManagerContext) {
        this.luceneWorkFactory = luceneWorkFactory;
        this.indexManagerContext = indexManagerContext;
    }

    public CompletableFuture<?> createIfMissing() {
        return this.doSubmit(this.luceneWorkFactory.createIndexIfMissing());
    }

    public CompletableFuture<?> createOrValidate(ContextualFailureCollector failureCollector) {
        return this.createIfMissing();
    }

    public CompletableFuture<?> createOrUpdate() {
        return this.createIfMissing();
    }

    public CompletableFuture<?> dropIfExisting() {
        return this.doSubmit(this.luceneWorkFactory.dropIndexIfExisting());
    }

    public CompletableFuture<?> dropAndCreate() {
        return this.doSubmit(this.luceneWorkFactory.dropIndexIfExisting()).thenCompose(ignored -> this.doSubmit(this.luceneWorkFactory.createIndexIfMissing()));
    }

    public CompletableFuture<?> validate(ContextualFailureCollector failureCollector) {
        return this.doSubmit(this.luceneWorkFactory.validateIndexExists());
    }

    private CompletableFuture<?> doSubmit(IndexManagementWork<?> work) {
        Collection<LuceneParallelWorkOrchestrator> orchestrators = this.indexManagerContext.getAllManagementOrchestrators();
        CompletableFuture[] futures = new CompletableFuture[orchestrators.size()];
        int i = 0;
        for (LuceneParallelWorkOrchestrator orchestrator : orchestrators) {
            futures[i] = orchestrator.submit(work);
            ++i;
        }
        return CompletableFuture.allOf(futures);
    }
}

