/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.extraction.impl;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TimeLimitingCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.TotalHits;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.ExplicitDocIdsQuery;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderMetadataResolver;
import org.hibernate.search.backend.lucene.search.extraction.impl.CollectorSet;
import org.hibernate.search.backend.lucene.search.timeout.impl.LuceneTimeoutManager;
import org.hibernate.search.engine.search.query.SearchResultTotal;
import org.hibernate.search.engine.search.query.spi.SimpleSearchResultTotal;

public class LuceneCollectors {
    static final CollectorKey<TotalHitCountCollector> TOTAL_HIT_COUNT_KEY = CollectorKey.create();
    static final CollectorKey<TopDocsCollector<?>> TOP_DOCS_KEY = CollectorKey.create();
    private final IndexReaderMetadataResolver metadataResolver;
    private final IndexSearcher indexSearcher;
    private final Query luceneQuery;
    private final boolean requireFieldDocRescoring;
    private final Integer scoreSortFieldIndexForRescoring;
    private final CollectorSet collectorsForAllMatchingDocs;
    private final Set<CollectorFactory<?>> collectorsForTopDocsFactories;
    private CollectorSet collectorsForTopDocs;
    private final LuceneTimeoutManager timeoutManager;
    private SearchResultTotal resultTotal;
    private TopDocs topDocs = null;

    LuceneCollectors(IndexReaderMetadataResolver metadataResolver, IndexSearcher indexSearcher, Query luceneQuery, boolean requireFieldDocRescoring, Integer scoreSortFieldIndexForRescoring, CollectorSet collectorsForAllMatchingDocs, Set<CollectorFactory<?>> collectorsForTopDocsFactories, LuceneTimeoutManager timeoutManager) {
        this.metadataResolver = metadataResolver;
        this.indexSearcher = indexSearcher;
        this.luceneQuery = luceneQuery;
        this.requireFieldDocRescoring = requireFieldDocRescoring;
        this.scoreSortFieldIndexForRescoring = scoreSortFieldIndexForRescoring;
        this.collectorsForAllMatchingDocs = collectorsForAllMatchingDocs;
        this.collectorsForTopDocsFactories = collectorsForTopDocsFactories;
        this.timeoutManager = timeoutManager;
    }

    public void collectMatchingDocs(int offset, Integer limit) throws IOException {
        TopDocsCollector<?> topDocsCollector;
        if (this.timeoutManager.checkTimedOut()) {
            this.resultTotal = SimpleSearchResultTotal.lowerBound((long)0L);
            return;
        }
        try {
            Collector composed = this.collectorsForAllMatchingDocs.getComposed();
            if (composed != null) {
                this.indexSearcher.search(this.luceneQuery, composed);
            }
        }
        catch (TimeLimitingCollector.TimeExceededException e) {
            this.timeoutManager.forceTimedOut();
        }
        TotalHitCountCollector totalHitCountCollector = this.collectorsForAllMatchingDocs.get(TOTAL_HIT_COUNT_KEY);
        if (totalHitCountCollector != null) {
            this.resultTotal = SimpleSearchResultTotal.exact((long)totalHitCountCollector.getTotalHits());
        }
        if ((topDocsCollector = this.collectorsForAllMatchingDocs.get(TOP_DOCS_KEY)) == null) {
            return;
        }
        this.extractTopDocs(topDocsCollector, offset, limit);
        if (this.resultTotal == null) {
            SimpleSearchResultTotal simpleSearchResultTotal = this.resultTotal = TotalHits.Relation.EQUAL_TO.equals((Object)this.topDocs.totalHits.relation) ? SimpleSearchResultTotal.exact((long)this.topDocs.totalHits.value) : SimpleSearchResultTotal.lowerBound((long)this.topDocs.totalHits.value);
        }
        if (this.requireFieldDocRescoring) {
            this.handleRescoring(this.indexSearcher, this.luceneQuery);
        }
    }

    public CollectorSet getCollectorsForAllMatchingDocs() {
        return this.collectorsForAllMatchingDocs;
    }

    public void collectTopDocsData(int startInclusive, int endExclusive) throws IOException {
        if (this.collectorsForTopDocsFactories.isEmpty() || this.topDocs == null) {
            this.collectorsForTopDocs = null;
            return;
        }
        try {
            ScoreDoc[] scoreDocs = this.topDocs.scoreDocs;
            ExplicitDocIdsQuery topDocsQuery = new ExplicitDocIdsQuery(scoreDocs, startInclusive, endExclusive);
            this.collectorsForTopDocs = this.buildTopdDocsDataCollectors(topDocsQuery);
            this.indexSearcher.search((Query)topDocsQuery, this.collectorsForTopDocs.getComposed());
        }
        catch (TimeLimitingCollector.TimeExceededException e) {
            this.timeoutManager.forceTimedOut();
        }
    }

    public CollectorSet getCollectorsForTopDocs() {
        return this.collectorsForTopDocs;
    }

    public SearchResultTotal getResultTotal() {
        return this.resultTotal;
    }

    public TopDocs getTopDocs() {
        return this.topDocs;
    }

    private void extractTopDocs(TopDocsCollector<?> topDocsCollector, int offset, Integer limit) {
        this.topDocs = limit == null ? topDocsCollector.topDocs(offset) : topDocsCollector.topDocs(offset, limit.intValue());
    }

    private void handleRescoring(IndexSearcher indexSearcher, Query luceneQuery) throws IOException {
        if (this.scoreSortFieldIndexForRescoring != null) {
            for (ScoreDoc scoreDoc : this.topDocs.scoreDocs) {
                FieldDoc fieldDoc = (FieldDoc)scoreDoc;
                fieldDoc.score = ((Float)fieldDoc.fields[this.scoreSortFieldIndexForRescoring]).floatValue();
            }
        } else {
            TopFieldCollector.populateScores((ScoreDoc[])this.topDocs.scoreDocs, (IndexSearcher)indexSearcher, (Query)luceneQuery);
        }
    }

    private CollectorSet buildTopdDocsDataCollectors(Query topDocsQuery) throws IOException {
        CollectorExecutionContext executionContext = new CollectorExecutionContext(this.metadataResolver, this.indexSearcher, topDocsQuery, this.topDocs.scoreDocs.length);
        CollectorSet.Builder collectorForTopDocsBuilder = new CollectorSet.Builder(executionContext, this.timeoutManager);
        collectorForTopDocsBuilder.addAll(this.collectorsForTopDocsFactories);
        return collectorForTopDocsBuilder.build();
    }
}

