/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchIndexesContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneBooleanPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneMatchAllPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneMatchIdPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneNestedPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateCollector;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSimpleQueryStringPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneUserProvidedLuceneQueryPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateTypeKeys;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneObjectPredicateBuilderFactory;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.BooleanPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.ExistsPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchAllPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchIdPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.NestedPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.PhrasePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SimpleQueryStringPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinBoundingBoxPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinCirclePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinPolygonPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.WildcardPredicateBuilder;

public class LuceneSearchPredicateBuilderFactoryImpl
implements LuceneSearchPredicateBuilderFactory {
    private final LuceneSearchContext searchContext;
    private final LuceneSearchIndexesContext indexes;

    public LuceneSearchPredicateBuilderFactoryImpl(LuceneSearchContext searchContext) {
        this.searchContext = searchContext;
        this.indexes = searchContext.indexes();
    }

    public void contribute(LuceneSearchPredicateCollector collector, SearchPredicate predicate) {
        LuceneSearchPredicate lucenePredicate = LuceneSearchPredicate.from(this.searchContext, predicate);
        collector.collectPredicate(lucenePredicate.toQuery(PredicateRequestContext.root()));
    }

    public MatchAllPredicateBuilder matchAll() {
        return new LuceneMatchAllPredicate.Builder(this.searchContext);
    }

    public MatchIdPredicateBuilder id() {
        return new LuceneMatchIdPredicate.Builder(this.searchContext);
    }

    public BooleanPredicateBuilder bool() {
        return new LuceneBooleanPredicate.Builder(this.searchContext);
    }

    public MatchPredicateBuilder match(String absoluteFieldPath) {
        return this.indexes.field(absoluteFieldPath).queryElement(PredicateTypeKeys.MATCH, this.searchContext);
    }

    public RangePredicateBuilder range(String absoluteFieldPath) {
        return this.indexes.field(absoluteFieldPath).queryElement(PredicateTypeKeys.RANGE, this.searchContext);
    }

    public PhrasePredicateBuilder phrase(String absoluteFieldPath) {
        return this.indexes.field(absoluteFieldPath).queryElement(PredicateTypeKeys.PHRASE, this.searchContext);
    }

    public WildcardPredicateBuilder wildcard(String absoluteFieldPath) {
        return this.indexes.field(absoluteFieldPath).queryElement(PredicateTypeKeys.WILDCARD, this.searchContext);
    }

    public SimpleQueryStringPredicateBuilder simpleQueryString() {
        return new LuceneSimpleQueryStringPredicate.Builder(this.searchContext, this.indexes);
    }

    public ExistsPredicateBuilder exists(String absoluteFieldPath) {
        LuceneObjectPredicateBuilderFactory objectPredicateBuilderFactory = this.indexes.objectPredicateBuilderFactory(absoluteFieldPath);
        if (objectPredicateBuilderFactory != null) {
            return objectPredicateBuilderFactory.createExistsPredicateBuilder(this.searchContext);
        }
        return this.indexes.field(absoluteFieldPath).queryElement(PredicateTypeKeys.EXISTS, this.searchContext);
    }

    public SpatialWithinCirclePredicateBuilder spatialWithinCircle(String absoluteFieldPath) {
        return this.indexes.field(absoluteFieldPath).queryElement(PredicateTypeKeys.SPATIAL_WITHIN_CIRCLE, this.searchContext);
    }

    public SpatialWithinPolygonPredicateBuilder spatialWithinPolygon(String absoluteFieldPath) {
        return this.indexes.field(absoluteFieldPath).queryElement(PredicateTypeKeys.SPATIAL_WITHIN_POLYGON, this.searchContext);
    }

    public SpatialWithinBoundingBoxPredicateBuilder spatialWithinBoundingBox(String absoluteFieldPath) {
        return this.indexes.field(absoluteFieldPath).queryElement(PredicateTypeKeys.SPATIAL_WITHIN_BOUNDING_BOX, this.searchContext);
    }

    public NestedPredicateBuilder nested(String absoluteFieldPath) {
        this.indexes.checkNestedField(absoluteFieldPath);
        List<String> nestedPathHierarchy = this.indexes.nestedPathHierarchyForObject(absoluteFieldPath);
        return new LuceneNestedPredicate.Builder(this.searchContext, absoluteFieldPath, nestedPathHierarchy);
    }

    @Override
    public LuceneSearchPredicate fromLuceneQuery(Query query) {
        return new LuceneUserProvidedLuceneQueryPredicate(this.searchContext, query);
    }
}

