/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.simple.SimpleQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.analysis.impl.ScopedAnalyzer;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.AnalyzerConstants;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneDifferentNestedObjectCompatibilityChecker;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchIndexesContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchValueFieldContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneNestablePredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateTypeKeys;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneSimpleQueryStringPredicateBuilderFieldState;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.BooleanOperator;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.SimpleQueryFlag;
import org.hibernate.search.engine.search.predicate.spi.SimpleQueryStringPredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneSimpleQueryStringPredicate
extends AbstractLuceneNestablePredicate {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final List<String> nestedPathHierarchy;
    private final List<String> fieldPaths;
    private final Query query;

    private LuceneSimpleQueryStringPredicate(Builder builder) {
        super(builder);
        this.nestedPathHierarchy = builder.nestedCompatibilityChecker.getNestedPathHierarchy();
        this.fieldPaths = new ArrayList(builder.fields.keySet());
        this.query = builder.buildQuery();
    }

    @Override
    protected Query doToQuery(PredicateRequestContext context) {
        return this.query;
    }

    @Override
    protected List<String> getNestedPathHierarchy() {
        return this.nestedPathHierarchy;
    }

    @Override
    protected List<String> getFieldPathsForErrorMessage() {
        return this.fieldPaths;
    }

    public static class Builder
    extends AbstractLuceneSearchPredicate.AbstractBuilder
    implements SimpleQueryStringPredicateBuilder {
        private final LuceneSearchIndexesContext indexes;
        private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;
        private final Map<String, LuceneSimpleQueryStringPredicateBuilderFieldState> fields = new LinkedHashMap<String, LuceneSimpleQueryStringPredicateBuilderFieldState>();
        private BooleanClause.Occur defaultOperator = BooleanClause.Occur.SHOULD;
        private String simpleQueryString;
        private Analyzer overrideAnalyzer;
        private boolean ignoreAnalyzer = false;
        private EnumSet<SimpleQueryFlag> flags;
        private LuceneDifferentNestedObjectCompatibilityChecker nestedCompatibilityChecker;

        Builder(LuceneSearchContext searchContext, LuceneSearchIndexesContext indexes) {
            super(searchContext);
            this.indexes = indexes;
            this.analysisDefinitionRegistry = searchContext.analysisDefinitionRegistry();
            this.nestedCompatibilityChecker = LuceneDifferentNestedObjectCompatibilityChecker.empty(indexes);
        }

        public void defaultOperator(BooleanOperator operator) {
            switch (operator) {
                case AND: {
                    this.defaultOperator = BooleanClause.Occur.MUST;
                    break;
                }
                case OR: {
                    this.defaultOperator = BooleanClause.Occur.SHOULD;
                }
            }
        }

        public void flags(Set<SimpleQueryFlag> flags) {
            this.flags = EnumSet.copyOf(flags);
        }

        public SimpleQueryStringPredicateBuilder.FieldState field(String absoluteFieldPath) {
            LuceneSimpleQueryStringPredicateBuilderFieldState field = this.fields.get(absoluteFieldPath);
            if (field == null) {
                LuceneSearchValueFieldContext<?> fieldContext = this.indexes.field(absoluteFieldPath);
                field = fieldContext.queryElement(PredicateTypeKeys.SIMPLE_QUERY_STRING, this.searchContext);
                this.nestedCompatibilityChecker = this.nestedCompatibilityChecker.combineAndCheck(absoluteFieldPath);
                this.fields.put(absoluteFieldPath, field);
            }
            return field;
        }

        public void simpleQueryString(String simpleQueryString) {
            this.simpleQueryString = simpleQueryString;
        }

        public void analyzer(String analyzerName) {
            this.overrideAnalyzer = this.analysisDefinitionRegistry.getAnalyzerDefinition(analyzerName);
            if (this.overrideAnalyzer == null) {
                throw log.unknownAnalyzer(analyzerName, EventContexts.fromIndexNames(this.indexes.indexNames()));
            }
        }

        public void skipAnalysis() {
            this.ignoreAnalyzer = true;
        }

        public SearchPredicate build() {
            return new LuceneSimpleQueryStringPredicate(this);
        }

        private Query buildQuery() {
            SimpleQueryParser queryParser = new SimpleQueryParser(this.buildAnalyzer(), this.buildWeights(), this.buildFlag());
            queryParser.setDefaultOperator(this.defaultOperator);
            return queryParser.parse(this.simpleQueryString);
        }

        private Analyzer buildAnalyzer() {
            if (this.ignoreAnalyzer) {
                return AnalyzerConstants.KEYWORD_ANALYZER;
            }
            if (this.overrideAnalyzer != null) {
                return this.overrideAnalyzer;
            }
            if (this.fields.size() == 1) {
                return this.fields.values().iterator().next().getAnalyzerOrNormalizer();
            }
            ScopedAnalyzer.Builder builder = new ScopedAnalyzer.Builder();
            for (Map.Entry<String, LuceneSimpleQueryStringPredicateBuilderFieldState> entry : this.fields.entrySet()) {
                builder.setAnalyzer(entry.getKey(), entry.getValue().getAnalyzerOrNormalizer());
            }
            return builder.build();
        }

        private Map<String, Float> buildWeights() {
            LinkedHashMap<String, Float> weights = new LinkedHashMap<String, Float>();
            for (Map.Entry<String, LuceneSimpleQueryStringPredicateBuilderFieldState> entry : this.fields.entrySet()) {
                LuceneSimpleQueryStringPredicateBuilderFieldState state = entry.getValue();
                Float boost = state.getBoost();
                if (boost == null) {
                    boost = Float.valueOf(1.0f);
                }
                weights.put(entry.getKey(), boost);
            }
            return weights;
        }

        private int buildFlag() {
            int flag = -1;
            if (this.flags != null) {
                flag = 0;
                for (SimpleQueryFlag operation : this.flags) {
                    switch (operation) {
                        case AND: {
                            flag |= 1;
                            break;
                        }
                        case NOT: {
                            flag |= 2;
                            break;
                        }
                        case OR: {
                            flag |= 4;
                            break;
                        }
                        case PREFIX: {
                            flag |= 8;
                            break;
                        }
                        case PHRASE: {
                            flag |= 0x10;
                            break;
                        }
                        case PRECEDENCE: {
                            flag |= 0x20;
                            break;
                        }
                        case ESCAPE: {
                            flag |= 0x40;
                            break;
                        }
                        case WHITESPACE: {
                            flag |= 0x80;
                            break;
                        }
                        case FUZZY: {
                            flag |= 0x100;
                            break;
                        }
                        case NEAR: {
                            flag |= 0x200;
                        }
                    }
                }
            }
            return flag;
        }
    }
}

