/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Explanation;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchIndexesContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchValueFieldContext;
import org.hibernate.search.backend.lucene.search.projection.impl.AbstractLuceneCompositeProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneCompositeBiFunctionProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneCompositeFunctionProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneCompositeListProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneCompositeTriFunctionProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneDocumentProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneDocumentReferenceProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneEntityProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneEntityReferenceProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneExplanationProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneScoreProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionTypeKeys;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.CompositeProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.DistanceToFieldProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.DocumentReferenceProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.EntityProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.EntityReferenceProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.FieldProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ScoreProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionBuilderFactory;
import org.hibernate.search.util.common.function.TriFunction;

public class LuceneSearchProjectionBuilderFactory
implements SearchProjectionBuilderFactory {
    private final LuceneSearchContext searchContext;
    private final LuceneSearchIndexesContext indexes;

    public LuceneSearchProjectionBuilderFactory(LuceneSearchContext searchContext) {
        this.searchContext = searchContext;
        this.indexes = searchContext.indexes();
    }

    public DocumentReferenceProjectionBuilder documentReference() {
        return new LuceneDocumentReferenceProjection.Builder(this.searchContext);
    }

    public <T> FieldProjectionBuilder<T> field(String absoluteFieldPath, Class<T> expectedType, ValueConvert convert) {
        LuceneSearchValueFieldContext<?> field = this.indexes.field(absoluteFieldPath);
        field.nestedPathHierarchy();
        return field.queryElement(ProjectionTypeKeys.FIELD, this.searchContext).type(expectedType, convert);
    }

    public <E> EntityProjectionBuilder<E> entity() {
        return new LuceneEntityProjection.Builder(this.searchContext);
    }

    public <R> EntityReferenceProjectionBuilder<R> entityReference() {
        return new LuceneEntityReferenceProjection.Builder(this.searchContext);
    }

    public ScoreProjectionBuilder score() {
        return new LuceneScoreProjection.Builder(this.searchContext);
    }

    public DistanceToFieldProjectionBuilder distance(String absoluteFieldPath) {
        LuceneSearchValueFieldContext<?> field = this.indexes.field(absoluteFieldPath);
        field.nestedPathHierarchy();
        return field.queryElement(ProjectionTypeKeys.DISTANCE, this.searchContext);
    }

    public <P> CompositeProjectionBuilder<P> composite(Function<List<?>, P> transformer, SearchProjection<?> ... projections) {
        ArrayList typedProjections = new ArrayList(projections.length);
        for (SearchProjection<?> projection : projections) {
            typedProjections.add(this.toImplementation(projection));
        }
        return new AbstractLuceneCompositeProjection.Builder<P>(new LuceneCompositeListProjection<P>(this.searchContext, transformer, typedProjections));
    }

    public <P1, P> CompositeProjectionBuilder<P> composite(Function<P1, P> transformer, SearchProjection<P1> projection) {
        return new AbstractLuceneCompositeProjection.Builder(new LuceneCompositeFunctionProjection<P1, P>(this.searchContext, transformer, this.toImplementation(projection)));
    }

    public <P1, P2, P> CompositeProjectionBuilder<P> composite(BiFunction<P1, P2, P> transformer, SearchProjection<P1> projection1, SearchProjection<P2> projection2) {
        return new AbstractLuceneCompositeProjection.Builder(new LuceneCompositeBiFunctionProjection<P1, P2, P>(this.searchContext, transformer, this.toImplementation(projection1), this.toImplementation(projection2)));
    }

    public <P1, P2, P3, P> CompositeProjectionBuilder<P> composite(TriFunction<P1, P2, P3, P> transformer, SearchProjection<P1> projection1, SearchProjection<P2> projection2, SearchProjection<P3> projection3) {
        return new AbstractLuceneCompositeProjection.Builder(new LuceneCompositeTriFunctionProjection<P1, P2, P3, P>(this.searchContext, transformer, this.toImplementation(projection1), this.toImplementation(projection2), this.toImplementation(projection3)));
    }

    public SearchProjectionBuilder<Document> document() {
        return new LuceneDocumentProjection.Builder(this.searchContext);
    }

    public SearchProjectionBuilder<Explanation> explanation() {
        return new LuceneExplanationProjection.Builder(this.searchContext);
    }

    private <T> LuceneSearchProjection<?, T> toImplementation(SearchProjection<T> projection) {
        return LuceneSearchProjection.from(this.searchContext, projection);
    }
}

