/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.HibernateSearchMultiReader;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneSyncWorkOrchestrator;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchResult;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchScroll;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchScrollResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneExtractableSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneLoadableSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchScrollResultImpl;
import org.hibernate.search.backend.lucene.search.timeout.impl.LuceneTimeoutManager;
import org.hibernate.search.backend.lucene.work.impl.LuceneSearcher;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.backend.lucene.work.impl.ReadWork;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneSearchScrollImpl<H>
implements LuceneSearchScroll<H> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneSyncWorkOrchestrator queryOrchestrator;
    private final LuceneWorkFactory workFactory;
    private final LuceneSearchContext searchContext;
    private final Set<String> routingKeys;
    private final LuceneTimeoutManager timeoutManager;
    private final LuceneSearcher<LuceneLoadableSearchResult<H>, LuceneExtractableSearchResult<H>> searcher;
    private final HibernateSearchMultiReader indexReader;
    private final int chunkSize;
    private int scrollIndex = 0;
    private int queryFetchSize;
    private LuceneExtractableSearchResult<H> search;

    public LuceneSearchScrollImpl(LuceneSyncWorkOrchestrator queryOrchestrator, LuceneWorkFactory workFactory, LuceneSearchContext searchContext, Set<String> routingKeys, LuceneTimeoutManager timeoutManager, LuceneSearcher<LuceneLoadableSearchResult<H>, LuceneExtractableSearchResult<H>> searcher, HibernateSearchMultiReader indexReader, int chunkSize) {
        this.queryOrchestrator = queryOrchestrator;
        this.workFactory = workFactory;
        this.searchContext = searchContext;
        this.routingKeys = routingKeys;
        this.timeoutManager = timeoutManager;
        this.searcher = searcher;
        this.indexReader = indexReader;
        this.chunkSize = chunkSize;
        this.queryFetchSize = chunkSize * 4;
    }

    public void close() {
        try {
            this.indexReader.close();
        }
        catch (IOException | RuntimeException e) {
            log.unableToCloseIndexReader(EventContexts.fromIndexNames(this.searchContext.indexes().indexNames()), e);
        }
    }

    public LuceneSearchScrollResult<H> next() {
        LuceneLoadableSearchResult<H> loadableSearchResult;
        this.timeoutManager.start();
        if (this.search == null || this.scrollIndex + this.chunkSize > this.queryFetchSize) {
            if (this.search != null) {
                this.queryFetchSize *= 2;
            }
            this.search = this.doSubmitWithIndexReader(this.workFactory.scroll(this.searcher, this.queryFetchSize), this.indexReader);
        }
        if (this.scrollIndex >= this.search.hitSize()) {
            return new LuceneSearchScrollResultImpl(false, Collections.emptyList(), Duration.ZERO, false);
        }
        int endIndexExclusive = this.scrollIndex + this.chunkSize;
        try {
            loadableSearchResult = this.search.extract(this.scrollIndex, endIndexExclusive);
        }
        catch (IOException e) {
            throw log.ioExceptionOnQueryExecution(this.searcher.getLuceneQueryForExceptions(), EventContexts.fromIndexNames(this.searchContext.indexes().indexNames()), e);
        }
        LuceneSearchResult<H> result = loadableSearchResult.loadBlocking();
        this.timeoutManager.stop();
        this.scrollIndex += this.chunkSize;
        return new LuceneSearchScrollResultImpl(true, result.hits(), result.took(), result.timedOut());
    }

    private <T> T doSubmitWithIndexReader(ReadWork<T> work, HibernateSearchMultiReader indexReader) {
        return this.queryOrchestrator.submit(this.searchContext.indexes().indexNames(), this.searchContext.indexes().elements(), this.routingKeys, work, indexReader);
    }
}

