/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TimeoutCountCollectorManager;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderMetadataResolver;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.search.extraction.impl.ExtractionRequirements;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectors;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneExtractableSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneLoadableSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryRequestContext;
import org.hibernate.search.backend.lucene.search.timeout.impl.LuceneTimeoutManager;
import org.hibernate.search.backend.lucene.work.impl.LuceneSearcher;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.util.common.logging.impl.DefaultLogCategories;
import org.hibernate.search.util.common.logging.impl.LogCategory;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class LuceneSearcherImpl<H>
implements LuceneSearcher<LuceneLoadableSearchResult<H>, LuceneExtractableSearchResult<H>> {
    private static final Log queryLog = (Log)LoggerFactory.make(Log.class, (LogCategory)DefaultLogCategories.QUERY);
    private final LuceneSearchQueryRequestContext requestContext;
    private final LuceneSearchProjection<?, H> rootProjection;
    private final Map<AggregationKey<?>, LuceneSearchAggregation<?>> aggregations;
    private final ExtractionRequirements extractionRequirements;
    private LuceneTimeoutManager timeoutManager;

    LuceneSearcherImpl(LuceneSearchQueryRequestContext requestContext, LuceneSearchProjection<?, H> rootProjection, Map<AggregationKey<?>, LuceneSearchAggregation<?>> aggregations, ExtractionRequirements extractionRequirements, LuceneTimeoutManager timeoutManager) {
        this.requestContext = requestContext;
        this.rootProjection = rootProjection;
        this.aggregations = aggregations;
        this.extractionRequirements = extractionRequirements;
        this.timeoutManager = timeoutManager;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("luceneQuery=").append(this.requestContext.getLuceneQuery()).append(", luceneSort=").append(this.requestContext.getLuceneSort()).append("]");
        return sb.toString();
    }

    @Override
    public LuceneLoadableSearchResult<H> search(IndexSearcher indexSearcher, IndexReaderMetadataResolver metadataResolver, int offset, Integer limit, int totalHitCountThreshold) throws IOException {
        queryLog.executingLuceneQuery(this.requestContext.getLuceneQuery());
        int maxDocs = this.getMaxDocs(indexSearcher.getIndexReader(), offset, limit);
        LuceneCollectors luceneCollectors = this.buildCollectors(indexSearcher, metadataResolver, maxDocs, totalHitCountThreshold);
        luceneCollectors.collectMatchingDocs(offset, limit);
        LuceneExtractableSearchResult<H> extractableSearchResult = new LuceneExtractableSearchResult<H>(this.requestContext, indexSearcher, luceneCollectors, this.rootProjection, this.aggregations, this.timeoutManager);
        return extractableSearchResult.extract(0, maxDocs);
    }

    @Override
    public LuceneExtractableSearchResult<H> scroll(IndexSearcher indexSearcher, IndexReaderMetadataResolver metadataResolver, int limit) throws IOException {
        queryLog.executingLuceneQuery(this.requestContext.getLuceneQuery());
        int offset = 0;
        int maxDocs = this.getMaxDocs(indexSearcher.getIndexReader(), offset, limit);
        LuceneCollectors luceneCollectors = this.buildCollectors(indexSearcher, metadataResolver, maxDocs, Integer.MAX_VALUE);
        luceneCollectors.collectMatchingDocs(offset, limit);
        return new LuceneExtractableSearchResult<H>(this.requestContext, indexSearcher, luceneCollectors, this.rootProjection, this.aggregations, this.timeoutManager);
    }

    @Override
    public int count(IndexSearcher indexSearcher) throws IOException {
        queryLog.executingLuceneQuery(this.requestContext.getLuceneQuery());
        if (this.timeoutManager.hasHardTimeout()) {
            return (Integer)indexSearcher.search(this.requestContext.getLuceneQuery(), (CollectorManager)new TimeoutCountCollectorManager(this.timeoutManager));
        }
        return indexSearcher.count(this.requestContext.getLuceneQuery());
    }

    @Override
    public Explanation explain(IndexSearcher indexSearcher, int luceneDocId) throws IOException {
        return indexSearcher.explain(this.requestContext.getLuceneQuery(), luceneDocId);
    }

    @Override
    public Query getLuceneQueryForExceptions() {
        return this.requestContext.getLuceneQuery();
    }

    @Override
    public void setTimeoutManager(LuceneTimeoutManager timeoutManager) {
        this.timeoutManager = timeoutManager;
    }

    private LuceneCollectors buildCollectors(IndexSearcher indexSearcher, IndexReaderMetadataResolver metadataResolver, int maxDocs, int totalHitCountThreshold) throws IOException {
        return this.extractionRequirements.createCollectors(indexSearcher, this.requestContext.getLuceneQuery(), this.requestContext.getLuceneSort(), metadataResolver, maxDocs, this.timeoutManager, totalHitCountThreshold);
    }

    private int getMaxDocs(IndexReader reader, int offset, Integer limit) {
        if (limit == null) {
            return reader.maxDoc();
        }
        if (limit.equals(0)) {
            return 0;
        }
        return Math.min(offset + limit, reader.maxDoc());
    }
}

