/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.converter.LuceneFieldContributor;
import org.hibernate.search.backend.lucene.types.converter.LuceneFieldValueExtractor;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class LuceneFieldFieldCodec<F>
implements LuceneFieldCodec<F> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneFieldContributor<F> fieldContributor;
    private final LuceneFieldValueExtractor<F> fieldValueExtractor;

    public LuceneFieldFieldCodec(LuceneFieldContributor<F> fieldContributor, LuceneFieldValueExtractor<F> fieldValueExtractor) {
        this.fieldContributor = fieldContributor;
        this.fieldValueExtractor = fieldValueExtractor;
    }

    @Override
    public void addToDocument(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, F value) {
        if (value == null) {
            return;
        }
        this.fieldContributor.contribute(absoluteFieldPath, value, f -> LuceneFieldFieldCodec.contributeField(documentBuilder, absoluteFieldPath, f));
    }

    @Override
    public F decode(IndexableField field) {
        if (this.fieldValueExtractor == null) {
            throw log.unsupportedProjectionForNativeField(EventContexts.fromIndexFieldAbsolutePath((String)field.name()));
        }
        return this.fieldValueExtractor.extract(field);
    }

    @Override
    public boolean isCompatibleWith(LuceneFieldCodec<?> obj) {
        if (this == obj) {
            return true;
        }
        if (LuceneFieldFieldCodec.class != obj.getClass()) {
            return false;
        }
        LuceneFieldFieldCodec other = (LuceneFieldFieldCodec)obj;
        return Objects.equals(this.fieldValueExtractor, other.fieldValueExtractor);
    }

    private static void contributeField(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, IndexableField field) {
        if (!absoluteFieldPath.equals(field.name())) {
            throw log.invalidFieldPath(absoluteFieldPath, field.name());
        }
        documentBuilder.addField(field);
    }
}

