/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSingleFieldPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.ExistsPredicateBuilder;

public class LuceneObjectExistsPredicate
extends AbstractLuceneSingleFieldPredicate {
    private final List<LuceneSearchPredicate> children;

    private LuceneObjectExistsPredicate(Builder builder) {
        super(builder);
        this.children = builder.children;
        builder.children = null;
    }

    @Override
    protected Query doToQuery(PredicateRequestContext context) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (LuceneSearchPredicate child : this.children) {
            builder.add(child.toQuery(context), BooleanClause.Occur.SHOULD);
        }
        return builder.build();
    }

    public static class Builder
    extends AbstractLuceneSingleFieldPredicate.AbstractBuilder
    implements ExistsPredicateBuilder {
        private List<LuceneSearchPredicate> children = new ArrayList<LuceneSearchPredicate>();

        public Builder(LuceneSearchContext searchContext, String absoluteFieldPath, List<String> nestedPathHierarchy) {
            super(searchContext, absoluteFieldPath, nestedPathHierarchy);
        }

        public void addChild(SearchPredicate child) {
            this.children.add(LuceneSearchPredicate.from(this.searchContext, child));
        }

        public SearchPredicate build() {
            return new LuceneObjectExistsPredicate(this);
        }
    }
}

