/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.backend.lucene.search.impl.AbstractLuceneSearchFieldQueryElementFactory;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchValueFieldContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneLeafSingleFieldPredicate;
import org.hibernate.search.backend.lucene.types.predicate.parse.impl.LuceneWildcardExpressionHelper;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.WildcardPredicateBuilder;

public class LuceneTextWildcardPredicate
extends AbstractLuceneLeafSingleFieldPredicate {
    private LuceneTextWildcardPredicate(Builder builder) {
        super(builder);
    }

    private static class Builder<F>
    extends AbstractLuceneLeafSingleFieldPredicate.AbstractBuilder<F>
    implements WildcardPredicateBuilder {
        private final Analyzer analyzerOrNormalizer;
        private String pattern;

        private Builder(LuceneSearchContext searchContext, LuceneSearchValueFieldContext<F> field) {
            super(searchContext, field);
            this.analyzerOrNormalizer = field.type().searchAnalyzerOrNormalizer();
        }

        public void pattern(String wildcardPattern) {
            this.pattern = wildcardPattern;
        }

        public SearchPredicate build() {
            return new LuceneTextWildcardPredicate(this);
        }

        @Override
        protected Query buildQuery() {
            BytesRef analyzedWildcard = LuceneWildcardExpressionHelper.analyzeWildcard(this.analyzerOrNormalizer, this.absoluteFieldPath, this.pattern);
            return new WildcardQuery(new Term(this.absoluteFieldPath, analyzedWildcard));
        }
    }

    public static class Factory<F>
    extends AbstractLuceneSearchFieldQueryElementFactory<WildcardPredicateBuilder, F> {
        @Override
        public Builder<F> create(LuceneSearchContext searchContext, LuceneSearchValueFieldContext<F> field) {
            return new Builder(searchContext, field);
        }
    }
}

