/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.execution.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntry;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntryFactory;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneSerialWorkOrchestrator;
import org.hibernate.search.backend.lucene.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.backend.lucene.work.impl.IndexingWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentContributor;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexer;

public class LuceneIndexIndexer
implements IndexIndexer {
    private final LuceneWorkFactory factory;
    private final LuceneIndexEntryFactory indexEntryFactory;
    private final WorkExecutionIndexManagerContext indexManagerContext;
    private final String tenantId;

    public LuceneIndexIndexer(LuceneWorkFactory factory, LuceneIndexEntryFactory indexEntryFactory, WorkExecutionIndexManagerContext indexManagerContext, BackendSessionContext sessionContext) {
        this.factory = factory;
        this.indexEntryFactory = indexEntryFactory;
        this.indexManagerContext = indexManagerContext;
        this.tenantId = sessionContext.tenantIdentifier();
    }

    public CompletableFuture<?> add(DocumentReferenceProvider referenceProvider, DocumentContributor documentContributor, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        String id = referenceProvider.identifier();
        String routingKey = referenceProvider.routingKey();
        LuceneIndexEntry indexEntry = this.indexEntryFactory.create(this.tenantId, id, routingKey, documentContributor);
        return this.submit(id, routingKey, this.factory.add(this.tenantId, this.indexManagerContext.getMappedTypeName(), referenceProvider.entityIdentifier(), id, indexEntry), commitStrategy, refreshStrategy);
    }

    public CompletableFuture<?> update(DocumentReferenceProvider referenceProvider, DocumentContributor documentContributor, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        String id = referenceProvider.identifier();
        String routingKey = referenceProvider.routingKey();
        LuceneIndexEntry indexEntry = this.indexEntryFactory.create(this.tenantId, id, routingKey, documentContributor);
        return this.submit(id, routingKey, this.factory.update(this.tenantId, this.indexManagerContext.getMappedTypeName(), referenceProvider.entityIdentifier(), id, indexEntry), commitStrategy, refreshStrategy);
    }

    public CompletableFuture<?> delete(DocumentReferenceProvider referenceProvider, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        String id = referenceProvider.identifier();
        String routingKey = referenceProvider.routingKey();
        return this.submit(id, routingKey, this.factory.delete(this.tenantId, this.indexManagerContext.getMappedTypeName(), referenceProvider.entityIdentifier(), id), commitStrategy, refreshStrategy);
    }

    private <T> CompletableFuture<T> submit(String documentId, String routingKey, IndexingWork<T> work, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        LuceneSerialWorkOrchestrator orchestrator = this.indexManagerContext.getIndexingOrchestrator(documentId, routingKey);
        CompletableFuture futureForOrchestrator = new CompletableFuture();
        boolean needsCommit = DocumentCommitStrategy.FORCE.equals((Object)commitStrategy);
        boolean needsRefresh = DocumentRefreshStrategy.FORCE.equals((Object)refreshStrategy);
        CompletionStage futureForCaller = needsCommit || needsRefresh ? futureForOrchestrator.thenApply(result -> {
            if (needsCommit) {
                orchestrator.forceCommitInCurrentThread();
            }
            if (needsRefresh) {
                orchestrator.forceRefreshInCurrentThread();
            }
            return result;
        }) : futureForOrchestrator;
        orchestrator.submit(futureForOrchestrator, work);
        return futureForCaller;
    }
}

