/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.AbstractLuceneNonFlattenedDocumentBuilder;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntry;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.util.impl.LuceneFields;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneRootDocumentBuilder
extends AbstractLuceneNonFlattenedDocumentBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final String indexName;
    private final FacetsConfig facetsConfig;

    LuceneRootDocumentBuilder(MultiTenancyStrategy multiTenancyStrategy, String indexName, FacetsConfig facetsConfig) {
        super(LuceneIndexSchemaObjectNode.root());
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.indexName = indexName;
        this.facetsConfig = facetsConfig;
    }

    public LuceneIndexEntry build(String tenantId, String id) {
        return new LuceneIndexEntry(this.indexName, id, this.assembleDocuments(this.indexName, this.multiTenancyStrategy, tenantId, id));
    }

    private List<Document> assembleDocuments(String indexName, MultiTenancyStrategy multiTenancyStrategy, String tenantId, String id) {
        this.document.add((IndexableField)new StringField(LuceneFields.typeFieldName(), "main", Field.Store.YES));
        this.document.add((IndexableField)new StringField(LuceneFields.indexFieldName(), indexName, Field.Store.YES));
        this.document.add((IndexableField)new StringField(LuceneFields.idFieldName(), id, Field.Store.YES));
        ArrayList<Document> documents = new ArrayList<Document>();
        this.contribute(indexName, multiTenancyStrategy, tenantId, id, documents);
        documents.add(this.document);
        if (this.facetsConfig != null) {
            for (int i = 0; i < documents.size(); ++i) {
                Document document = (Document)documents.get(i);
                try {
                    Document facetedDocument = this.facetsConfig.build(document);
                    documents.set(i, facetedDocument);
                    continue;
                }
                catch (IOException | RuntimeException e) {
                    throw log.errorDuringFacetingIndexing(e);
                }
            }
        }
        return documents;
    }
}

