/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.impl;

import java.lang.invoke.MethodHandles;
import java.text.ParseException;
import java.util.Locale;
import java.util.Optional;
import org.apache.lucene.util.Version;
import org.hibernate.search.backend.lucene.analysis.LuceneAnalysisConfigurer;
import org.hibernate.search.backend.lucene.analysis.impl.LuceneAnalysisComponentFactory;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneAnalysisConfigurationContextImpl;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.cfg.LuceneBackendSettings;
import org.hibernate.search.backend.lucene.impl.LuceneBackendImpl;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.directory.impl.DirectoryProviderInitializationContextImpl;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryProvider;
import org.hibernate.search.backend.lucene.multitenancy.MultiTenancyStrategyName;
import org.hibernate.search.backend.lucene.multitenancy.impl.DiscriminatorMultiTenancyStrategy;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.multitenancy.impl.NoMultiTenancyStrategy;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactoryImpl;
import org.hibernate.search.engine.backend.spi.BackendBuildContext;
import org.hibernate.search.engine.backend.spi.BackendFactory;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneBackendFactory
implements BackendFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<Optional<Version>> LUCENE_VERSION = ConfigurationProperty.forKey((String)"lucene_version").as(Version.class, LuceneBackendFactory::parseLuceneVersion).build();
    private static final ConfigurationProperty<MultiTenancyStrategyName> MULTI_TENANCY_STRATEGY = ConfigurationProperty.forKey((String)"multi_tenancy.strategy").as(MultiTenancyStrategyName.class, MultiTenancyStrategyName::of).withDefault((Object)LuceneBackendSettings.Defaults.MULTI_TENANCY_STRATEGY).build();
    private static final OptionalConfigurationProperty<BeanReference<? extends LuceneAnalysisConfigurer>> ANALYSIS_CONFIGURER = ConfigurationProperty.forKey((String)"analysis.configurer").asBeanReference(LuceneAnalysisConfigurer.class).build();

    public BackendImplementor<?> create(String name, BackendBuildContext buildContext, ConfigurationPropertySource propertySource) {
        EventContext backendContext = EventContexts.fromBackendName((String)name);
        Version luceneVersion = this.getLuceneVersion(backendContext, propertySource);
        BeanHolder<? extends DirectoryProvider> directoryProviderHolder = this.getDirectoryProvider(backendContext, buildContext, propertySource);
        MultiTenancyStrategy multiTenancyStrategy = this.getMultiTenancyStrategy(propertySource);
        LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry = this.getAnalysisDefinitionRegistry(buildContext, propertySource, luceneVersion);
        return new LuceneBackendImpl(name, directoryProviderHolder, buildContext.getThreadPoolProvider(), new LuceneWorkFactoryImpl(multiTenancyStrategy), analysisDefinitionRegistry, multiTenancyStrategy, buildContext.getFailureHandler());
    }

    private Version getLuceneVersion(EventContext backendContext, ConfigurationPropertySource propertySource) {
        Version luceneVersion;
        Optional luceneVersionOptional = (Optional)LUCENE_VERSION.get(propertySource);
        if (luceneVersionOptional.isPresent()) {
            luceneVersion = (Version)luceneVersionOptional.get();
            if (log.isDebugEnabled()) {
                log.debug("Setting Lucene compatibility to Version " + luceneVersion);
            }
        } else {
            Version latestVersion = LuceneBackendSettings.Defaults.LUCENE_VERSION;
            log.recommendConfiguringLuceneVersion(LUCENE_VERSION.resolveOrRaw(propertySource), latestVersion, backendContext);
            luceneVersion = latestVersion;
        }
        return luceneVersion;
    }

    private BeanHolder<? extends DirectoryProvider> getDirectoryProvider(EventContext backendContext, BackendBuildContext buildContext, ConfigurationPropertySource propertySource) {
        DirectoryProviderInitializationContextImpl initializationContext = new DirectoryProviderInitializationContextImpl(backendContext, buildContext.getBeanResolver(), propertySource.withMask("directory"));
        return initializationContext.createDirectoryProvider();
    }

    private MultiTenancyStrategy getMultiTenancyStrategy(ConfigurationPropertySource propertySource) {
        MultiTenancyStrategyName multiTenancyStrategyName = (MultiTenancyStrategyName)((Object)MULTI_TENANCY_STRATEGY.get(propertySource));
        switch (multiTenancyStrategyName) {
            case NONE: {
                return new NoMultiTenancyStrategy();
            }
            case DISCRIMINATOR: {
                return new DiscriminatorMultiTenancyStrategy();
            }
        }
        throw new AssertionFailure(String.format(Locale.ROOT, "Unsupported multi-tenancy strategy '%1$s'.", new Object[]{multiTenancyStrategyName}));
    }

    private LuceneAnalysisDefinitionRegistry getAnalysisDefinitionRegistry(BackendBuildContext buildContext, ConfigurationPropertySource propertySource, Version luceneVersion) {
        try {
            BeanResolver beanResolver = buildContext.getBeanResolver();
            return ANALYSIS_CONFIGURER.getAndMap(propertySource, arg_0 -> ((BeanResolver)beanResolver).resolve(arg_0)).map(holder -> {
                try (BeanHolder configurerHolder = holder;){
                    LuceneAnalysisComponentFactory analysisComponentFactory = new LuceneAnalysisComponentFactory(luceneVersion, buildContext.getClassResolver(), buildContext.getResourceResolver());
                    LuceneAnalysisConfigurationContextImpl collector = new LuceneAnalysisConfigurationContextImpl(analysisComponentFactory);
                    ((LuceneAnalysisConfigurer)configurerHolder.get()).configure(collector);
                    LuceneAnalysisDefinitionRegistry luceneAnalysisDefinitionRegistry = new LuceneAnalysisDefinitionRegistry(collector);
                    return luceneAnalysisDefinitionRegistry;
                }
            }).orElseGet(LuceneAnalysisDefinitionRegistry::new);
        }
        catch (Exception e) {
            throw log.unableToApplyAnalysisConfiguration(e.getMessage(), e);
        }
    }

    private static Version parseLuceneVersion(String versionString) {
        try {
            return Version.parseLeniently((String)versionString);
        }
        catch (IllegalArgumentException | ParseException e) {
            throw log.illegalLuceneVersionFormat(versionString, e.getMessage(), e);
        }
    }
}

