/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.LuceneBackend;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.document.impl.LuceneRootDocumentBuilder;
import org.hibernate.search.backend.lucene.document.model.dsl.impl.LuceneIndexSchemaRootNodeBuilder;
import org.hibernate.search.backend.lucene.index.impl.IndexManagerBackendContext;
import org.hibernate.search.backend.lucene.index.impl.LuceneIndexManagerBuilder;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryProvider;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneReadWorkOrchestratorImpl;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneReadWorkOrchestratorImplementor;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.backend.Backend;
import org.hibernate.search.engine.backend.index.spi.IndexManagerBuilder;
import org.hibernate.search.engine.backend.spi.BackendBuildContext;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.backend.spi.BackendStartContext;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.thread.spi.ThreadPoolProvider;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneBackendImpl
implements BackendImplementor<LuceneRootDocumentBuilder>,
LuceneBackend {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String name;
    private final BeanHolder<? extends DirectoryProvider> directoryProviderHolder;
    private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private final LuceneReadWorkOrchestratorImplementor readOrchestrator;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final EventContext eventContext;
    private final IndexManagerBackendContext indexManagerBackendContext;

    LuceneBackendImpl(String name, BeanHolder<? extends DirectoryProvider> directoryProviderHolder, ThreadPoolProvider threadPoolProvider, LuceneWorkFactory workFactory, LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry, MultiTenancyStrategy multiTenancyStrategy, FailureHandler failureHandler) {
        this.name = name;
        this.directoryProviderHolder = directoryProviderHolder;
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
        this.readOrchestrator = new LuceneReadWorkOrchestratorImpl("Lucene read work orchestrator for backend " + name);
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.eventContext = EventContexts.fromBackendName((String)name);
        this.indexManagerBackendContext = new IndexManagerBackendContext(this.eventContext, (DirectoryProvider)directoryProviderHolder.get(), workFactory, multiTenancyStrategy, analysisDefinitionRegistry, threadPoolProvider, failureHandler, this.readOrchestrator);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "name=" + this.name + ", " + "directoryProvider=" + this.directoryProviderHolder.get() + "]";
    }

    public void start(BackendStartContext context) {
    }

    public CompletableFuture<?> preStop() {
        return CompletableFuture.completedFuture(null);
    }

    public void stop() {
        try (Closer closer = new Closer();){
            closer.push(LuceneReadWorkOrchestratorImplementor::stop, (Object)this.readOrchestrator);
            closer.push(holder -> ((DirectoryProvider)holder.get()).close(), this.directoryProviderHolder);
            closer.push(BeanHolder::close, this.directoryProviderHolder);
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(LuceneBackend.class)) {
            return (T)this;
        }
        throw log.backendUnwrappingWithUnknownType(clazz, LuceneBackend.class, this.eventContext);
    }

    public Backend toAPI() {
        return this;
    }

    public IndexManagerBuilder<LuceneRootDocumentBuilder> createIndexManagerBuilder(String indexName, boolean multiTenancyEnabled, BackendBuildContext context, ConfigurationPropertySource propertySource) {
        if (multiTenancyEnabled && !this.multiTenancyStrategy.isMultiTenancySupported()) {
            throw log.multiTenancyRequiredButNotSupportedByBackend(indexName, this.eventContext);
        }
        LuceneIndexSchemaRootNodeBuilder indexSchemaRootNodeBuilder = new LuceneIndexSchemaRootNodeBuilder(EventContexts.fromIndexName((String)indexName), this.analysisDefinitionRegistry);
        return new LuceneIndexManagerBuilder(this.indexManagerBackendContext, indexName, indexSchemaRootNodeBuilder);
    }
}

