/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.logging.impl;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.hibernate.search.backend.lucene.index.LuceneIndexManager;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LuceneFieldAggregationBuilderFactory;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.logging.spi.AggregationKeyFormatter;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.EventContextFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;

@MessageLogger(projectCode="HSEARCH")
@ValidIdRanges(value={@ValidIdRange(min=600000, max=609999), @ValidIdRange(min=35, max=35), @ValidIdRange(min=49, max=49), @ValidIdRange(min=52, max=52), @ValidIdRange(min=55, max=55), @ValidIdRange(min=75, max=75), @ValidIdRange(min=114, max=114), @ValidIdRange(min=118, max=118), @ValidIdRange(min=225, max=225), @ValidIdRange(min=228, max=228), @ValidIdRange(min=265, max=265), @ValidIdRange(min=284, max=284), @ValidIdRange(min=320, max=320), @ValidIdRange(min=321, max=321), @ValidIdRange(min=329, max=329), @ValidIdRange(min=330, max=330), @ValidIdRange(min=337, max=337), @ValidIdRange(min=341, max=341), @ValidIdRange(min=342, max=342), @ValidIdRange(min=344, max=344), @ValidIdRange(min=345, max=345), @ValidIdRange(min=353, max=353)})
public interface Log
extends BasicLogger {
    public static final int ID_OFFSET_1 = 0;
    public static final int ID_OFFSET_2 = 600000;

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=49, value="'%s' was interrupted while waiting for index activity to finish. Index might be inconsistent or have a stale lock")
    public void interruptedWhileWaitingForIndexActivity(String var1, @Cause InterruptedException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=52, value="Going to force release of the IndexWriter lock. %1$s")
    public void forcingReleaseIndexWriterLock(@FormatWith(value=EventContextFormatter.class) EventContext var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=55, value="Unable to close the index reader. %1$s")
    public void unableToCloseIndexReader(@FormatWith(value=EventContextFormatter.class) EventContext var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=75, value="Configuration setting '%1$s' was not specified: using LATEST (currently '%2$s'). %3$s")
    public void recommendConfiguringLuceneVersion(String var1, Version var2, @FormatWith(value=EventContextFormatter.class) EventContext var3);

    @Message(id=114, value="Could not load resource: '%1$s'")
    public SearchException unableToLoadResource(String var1);

    @Message(id=118, value="Index Merge operation")
    public String indexMergeOperation();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=225, value="An index locking error occurred during initialization of Directory '%s'. This might indicate a concurrent initialization; If you experience errors on this index you might need to remove the lock, or rebuild the index.")
    public void lockingFailureDuringInitialization(String var1, @Param EventContext var2);

    @Message(id=228, value="Value '%1$ss' is not in a valid format to express a Lucene version: %2$s")
    public SearchException illegalLuceneVersionFormat(String var1, String var2, @Cause Exception var3);

    @Message(id=265, value="Unable to build Lucene Document due to facet indexing error")
    public SearchException errorDuringFacetingIndexing(@Cause Exception var1);

    @Message(id=284, value="An exception occurred while opening multiple indexes.")
    public SearchException failureOnMultiReaderRefresh(@Param EventContext var1, @Cause Exception var2);

    @Message(id=320, value="Could not normalize value for field '%1$s'.")
    public SearchException couldNotNormalizeField(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=321, value="The analysis of field '%1$s' produced multiple tokens. Tokenization or term generation (synonyms) should not be used on sortable fields or range queries. Only the first token will be considered.")
    public void multipleTermsDetectedDuringNormalization(String var1);

    @Message(id=329, value="Error while applying analysis configuration: %1$s")
    public SearchException unableToApplyAnalysisConfiguration(String var1, @Cause Exception var2);

    @Message(id=330, value="Multiple analyzer definitions with the same name: '%1$s'. The analyzer names must be unique.")
    public SearchException analyzerDefinitionNamingConflict(String var1);

    @Message(id=337, value="Multiple parameters with the same name: '%1$s'. Can't assign both value '%2$s' and '%3$s'")
    public SearchException analysisComponentParameterConflict(String var1, String var2, String var3);

    @Message(id=341, value="Multiple normalizer definitions with the same name: '%1$s'. The normalizer names must be unique.")
    public SearchException normalizerDefinitionNamingConflict(String var1);

    @Message(id=342, value="Cannot apply both an analyzer and a normalizer. Analyzer: '%1$s', normalizer: '%2$s'.")
    public SearchException cannotApplyAnalyzerAndNormalizer(String var1, String var2, @Param EventContext var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=344, value="The normalizer for definition '%s' produced %d tokens. Normalizers should never produce more than one token. The tokens have been concatenated by Hibernate Search, but you should fix your normalizer definition.")
    public void normalizerProducedMultipleTokens(String var1, int var2);

    @Message(id=345, value="Cannot apply an analyzer on a sortable field. Use a normalizer instead. Analyzer: '%1$s'. If an actual analyzer (with tokenization) is necessary, define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.")
    public SearchException cannotUseAnalyzerOnSortableField(String var1, @Param EventContext var2);

    @Message(id=353, value="Unknown analyzer: '%1$s'. Make sure you defined this analyzer.")
    public SearchException unknownAnalyzer(String var1, @Param EventContext var2);

    @Message(id=600000, value="Unknown field '%1$s'.")
    public SearchException unknownFieldForSearch(String var1, @Param EventContext var2);

    @Message(id=600001, value="Path '%1$s' exists but does not point to a writable directory.")
    public SearchException pathIsNotWriteableDirectory(Path var1);

    @Message(id=600002, value="Unable to initialize root directory '%1$s': %2$s")
    public SearchException unableToInitializeRootDirectory(Path var1, String var2, @Cause Exception var3);

    @Message(id=600005, value="The Lucene extension can only be applied to objects derived from the Lucene backend. Was applied to '%1$s' instead.")
    public SearchException luceneExtensionOnUnknownType(Object var1);

    @Message(id=600010, value="A Lucene query cannot include search predicates built using a non-Lucene search scope. Given predicate was: '%1$s'")
    public SearchException cannotMixLuceneSearchQueryWithOtherPredicates(SearchPredicate var1);

    @Message(id=600012, value="Field '%1$s' is not an object field.")
    public SearchException nonObjectFieldForNestedQuery(String var1, @Param EventContext var2);

    @Message(id=600013, value="Object field '%1$s' is not stored as nested.")
    public SearchException nonNestedFieldForNestedQuery(String var1, @Param EventContext var2);

    @Message(id=600014, value="A Lucene query cannot include search sorts built using a non-Lucene search scope. Given sort was: '%1$s'")
    public SearchException cannotMixLuceneSearchSortWithOtherSorts(SearchSort var1);

    @Message(id=600015, value="Unable to initialize index directory: %1$s")
    public SearchException unableToInitializeIndexDirectory(String var1, @Param EventContext var2, @Cause Exception var3);

    @Message(id=600016, value="Unable to index entry '%2$s' with tenant identifier '%1$s'.")
    public SearchException unableToIndexEntry(String var1, String var2, @Param EventContext var3, @Cause Exception var4);

    @Message(id=600017, value="Unable to delete entry '%2$s' with tenant identifier '%1$s'.")
    public SearchException unableToDeleteEntryFromIndex(String var1, String var2, @Param EventContext var3, @Cause Exception var4);

    @Message(id=600018, value="Unable to flush.")
    public SearchException unableToFlushIndex(@Param EventContext var1, @Cause Exception var2);

    @Message(id=600019, value="Unable to commit.")
    public SearchException unableToCommitIndex(@Param EventContext var1, @Cause Exception var2);

    @Message(id=600022, value="Could not open an index reader.")
    public SearchException unableToCreateIndexReader(@Param EventContext var1, @Cause Exception var2);

    @Message(id=600024, value="A multi-index scope cannot include both a Lucene index and another type of index. Base scope was: '%1$s', Lucene index was: '%2$s'")
    public SearchException cannotMixLuceneScopeWithOtherType(IndexScopeBuilder var1, LuceneIndexManager var2, @Param EventContext var3);

    @Message(id=600025, value="A multi-index scope cannot span multiple Lucene backends. Base scope was: '%1$s', index from another backend was: '%2$s'")
    public SearchException cannotMixLuceneScopeWithOtherBackend(IndexScopeBuilder var1, LuceneIndexManager var2, @Param EventContext var3);

    @Message(id=600027, value="An IOException happened while executing the query '%1$s'.")
    public SearchException ioExceptionOnQueryExecution(Query var1, @Param EventContext var2, @Cause IOException var3);

    @Message(id=600029, value="Index '%1$s' requires multi-tenancy but the backend does not support it in its current configuration.")
    public SearchException multiTenancyRequiredButNotSupportedByBackend(String var1, @Param EventContext var2);

    @Message(id=600030, value="Invalid multi-tenancy strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidMultiTenancyStrategyName(String var1, List<String> var2);

    @Message(id=600031, value="Tenant identifier '%1$s' is provided, but multi-tenancy is disabled for this backend.")
    public SearchException tenantIdProvidedButMultiTenancyDisabled(String var1, @Param EventContext var2);

    @Message(id=600032, value="Backend has multi-tenancy enabled, but no tenant identifier is provided.")
    public SearchException multiTenancyEnabledButNoTenantIdProvided(@Param EventContext var1);

    @Message(id=600033, value="Attempt to unwrap a Lucene backend to '%1$s', but this backend can only be unwrapped to '%2$s'.")
    public SearchException backendUnwrappingWithUnknownType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=600034, value="The index schema node '%1$s' was added twice. Multiple bridges may be trying to access the same index field,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.")
    public SearchException indexSchemaNodeNameConflict(String var1, @Param EventContext var2);

    @Message(id=600037, value="Range lookups (range predicates, range aggregations) are not supported by this field's type (GeoPoint). Use spatial features instead.")
    public SearchException rangesNotSupportedByGeoPoint(@Param EventContext var1);

    @Message(id=600038, value="Direct value lookups (match predicates, terms aggregations) are not supported by this field's type (GeoPoint). Use spatial features instead.")
    public SearchException directValueLookupNotSupportedByGeoPoint(@Param EventContext var1);

    @Message(id=600039, value="Invalid field reference for this document element: this document element has path '%1$s', but the referenced field has a parent with path '%2$s'.")
    public SearchException invalidFieldForDocumentElement(String var1, String var2);

    @Message(id=600040, value="Spatial predicates are not supported by this field's type.")
    public SearchException spatialPredicatesNotSupportedByFieldType(@Param EventContext var1);

    @Message(id=600041, value="Distance related operations are not supported by this field's type.")
    public SearchException distanceOperationsNotSupportedByFieldType(@Param EventContext var1);

    @Message(id=600042, value="Traditional sorting operations are not supported by the GeoPoint field type, use distance sorting instead.")
    public SearchException traditionalSortNotSupportedByGeoPoint(@Param EventContext var1);

    @Message(id=600044, value="Computed minimum for minimumShouldMatch constraint is out of bounds: expected a number between '1' and '%1$s', got '%2$s'.")
    public SearchException minimumShouldMatchMinimumOutOfBounds(int var1, int var2);

    @Message(id=600045, value="Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'")
    public SearchException minimumShouldMatchConflictingConstraints(int var1);

    @Message(id=600046, value="Native fields do not support defining predicates with the DSL: use the Lucene extension and a native query.")
    public SearchException unsupportedDSLPredicates(@Param EventContext var1);

    @Message(id=600047, value="Native fields do not support defining sorts with the DSL: use the Lucene extension and a native sort.")
    public SearchException unsupportedDSLSorts(@Param EventContext var1);

    @Message(id=600048, value="This native field does not support projection.")
    public SearchException unsupportedProjection(@Param EventContext var1);

    @Message(id=600049, value="Invalid field path; expected path '%1$s', got '%2$s'.")
    public SearchException invalidFieldPath(String var1, String var2);

    @Message(id=600050, value="Unable to convert DSL parameter: %1$s")
    public SearchException cannotConvertDslParameter(String var1, @Cause Exception var2, @Param EventContext var3);

    @Message(id=600051, value="Attempt to unwrap a Lucene index manager to '%1$s', but this index manager can only be unwrapped to '%2$s'.")
    public SearchException indexManagerUnwrappingWithUnknownType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=600052, value="Unable to create analyzer for name '%1$s'.")
    public SearchException unableToCreateAnalyzer(String var1, @Cause Exception var2);

    @Message(id=600053, value="Unable to create normalizer for name '%1$s'.")
    public SearchException unableToCreateNormalizer(String var1, @Cause Exception var2);

    @Message(id=600054, value="Unknown normalizer: '%1$s'. Make sure you defined this normalizer.")
    public SearchException unknownNormalizer(String var1, @Param EventContext var2);

    @Message(id=600055, value="A Lucene query cannot include search projections built using a non-Lucene search scope. Given projection was: '%1$s'")
    public SearchException cannotMixLuceneSearchQueryWithOtherProjections(SearchProjection<?> var1);

    @Message(id=600056, value="Invalid type '%2$s' for projection on field '%1$s'.")
    public SearchException invalidProjectionInvalidType(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=600057, value="This field does not support projections.")
    public SearchException unsupportedDSLProjections(@Param EventContext var1);

    @Message(id=600058, value="Multiple conflicting types to build a predicate for field '%1$s': '%2$s' vs. '%3$s'.")
    public SearchException conflictingFieldTypesForPredicate(String var1, LuceneFieldPredicateBuilderFactory var2, LuceneFieldPredicateBuilderFactory var3, @Param EventContext var4);

    @Message(id=600059, value="Multiple conflicting types to build a sort for field '%1$s': '%2$s' vs. '%3$s'.")
    public SearchException conflictingFieldTypesForSort(String var1, LuceneFieldSortBuilderFactory var2, LuceneFieldSortBuilderFactory var3, @Param EventContext var4);

    @Message(id=600060, value="Multiple conflicting types to build a projection for field '%1$s': '%2$s' vs. '%3$s'.")
    public SearchException conflictingFieldTypesForProjection(String var1, LuceneFieldProjectionBuilderFactory var2, LuceneFieldProjectionBuilderFactory var3, @Param EventContext var4);

    @Message(id=600061, value="Failed to shut down the Lucene index manager.")
    public SearchException failedToShutdownBackend(@Cause Exception var1, @Param EventContext var2);

    @Message(id=600062, value="Cannot guess field type for input type: '%1$s'.")
    public SearchException cannotGuessFieldType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @Param EventContext var2);

    @Message(id=600064, value="Unexpected index: documentId '%1$s' was not collected.")
    public SearchException documentIdNotCollected(Integer var1);

    @Message(id=600065, value="Projections are not enabled for field '%1$s'. Make sure the field is marked as projectable.")
    public SearchException nonProjectableField(String var1, @Param EventContext var2);

    @Message(id=600066, value="Sorting is not enabled for field '%1$s'. Make sure the field is marked as sortable.")
    public SearchException unsortableField(String var1, @Param EventContext var2);

    @Message(id=600067, value="Unable to delete all entries with tenant identifier '%1$s'.")
    public SearchException unableToDeleteAllEntriesFromIndex(String var1, @Param EventContext var2, @Cause Exception var3);

    @Message(id=600068, value="Multiple conflicting types for identifier: '%1$s' vs. '%2$s'.")
    public SearchException conflictingIdentifierTypesForPredicate(ToDocumentIdentifierValueConverter<?> var1, ToDocumentIdentifierValueConverter<?> var2, @Param EventContext var3);

    @Message(id=600069, value="An IOException occurred while generating an Explanation.")
    public SearchException ioExceptionOnExplain(@Cause IOException var1);

    @Message(id=600070, value="Text predicates (phrase, fuzzy, wildcard, simple query string) are not supported by this field's type.")
    public SearchException textPredicatesNotSupportedByFieldType(@Param EventContext var1);

    @Message(id=600071, value="Incomplete field definition. You must call toReference() to complete the field definition.")
    public SearchException incompleteFieldDefinition(@Param EventContext var1);

    @Message(id=600072, value="Multiple calls to toReference() for the same field definition. You must call toReference() exactly once.")
    public SearchException cannotCreateReferenceMultipleTimes(@Param EventContext var1);

    @Message(id=600073, value="Index-null-as option is not supported on analyzed field. Trying to define the analyzer: '%1$s' together with index null as: '%2$s'.")
    public SearchException cannotUseIndexNullAsAndAnalyzer(String var1, String var2, @Param EventContext var3);

    @Message(id=600074, value="Multiple values were added to single-valued field '%1$s'. Declare the field as multi-valued in order to allow this.")
    public SearchException multipleValuesForSingleValuedField(String var1);

    @Message(id=600075, value="explain(String id) cannot be used when the query targets multiple indexes. Use explain(String indexName, String id) and pass one of %1$s as the index name.")
    public SearchException explainRequiresIndexName(Set<String> var1);

    @Message(id=600076, value="The given index name '%2$s' is not among the indexes targeted by this query: %1$s.")
    public SearchException explainRequiresIndexTargetedByQuery(Set<String> var1, String var2);

    @Message(id=600077, value="Document with id '%2$s' does not exist in index '%1$s' and thus its match cannot be explained.")
    public SearchException explainUnkownDocument(String var1, String var2);

    @Message(id=600078, value="Unable to optimize.")
    public SearchException unableToOptimizeIndex(@Param EventContext var1, @Cause Exception var2);

    @Message(id=600079, value="Unable to clean up after write errors.")
    public SearchException unableToCleanUpAfterError(@Param EventContext var1, @Cause Exception var2);

    @Message(id=600080, value="Impossible to detect a decimal scale to use for this field. If the value is bridged, set '.asBigDecimal().decimalScale( int )' in the bind, else verify your mapping.")
    public SearchException nullDecimalScale(@Param EventContext var1);

    @Message(id=600081, value="The value '%1$s' cannot be indexed because its absolute value is too large.")
    public SearchException scaledNumberTooLarge(Number var1);

    @Message(id=600082, value="Positive decimal scale ['%1$s'] is not allowed for BigInteger fields, since a BigInteger value cannot have any decimal digits.")
    public SearchException invalidDecimalScale(Integer var1, @Param EventContext var2);

    @Message(id=600083, value="Field '%1$s' is not searchable. Make sure the field is marked as searchable.")
    public SearchException nonSearchableField(String var1, @Param EventContext var2);

    @Message(id=600084, value="The predicate '%1$s' is defined on a scope targeting different indexes. Predicate is targeting: '%2$s'. Current scope is targeting: '%3$s'.")
    public SearchException predicateDefinedOnDifferentIndexes(SearchPredicate var1, Set<String> var2, Set<String> var3);

    @Message(id=600085, value="The sort '%1$s' is defined on a scope targeting different indexes. Sort is targeting: '%2$s'. Current scope is targeting: '%3$s'.")
    public SearchException sortDefinedOnDifferentIndexes(SearchSort var1, Set<String> var2, Set<String> var3);

    @Message(id=600086, value="The projection '%1$s' is defined on a scope targeting different indexes. Projection is targeting: '%2$s'. Current scope is targeting: '%3$s'.")
    public SearchException projectionDefinedOnDifferentIndexes(SearchProjection<?> var1, Set<String> var2, Set<String> var3);

    @Message(id=600087, value="Invalid filesystem access strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidFileSystemAccessStrategyName(String var1, List<String> var2);

    @Message(id=600088, value="Invalid locking strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidLockingStrategyName(String var1, List<String> var2);

    @Message(id=600089, value="The sharding strategy '%1$s' is not implemented properly: it must call either context.setShardIdentifiers() or context.setShardingDisabled() in its initialize() method, but it did not.")
    public SearchException missingShardIdentifiersAfterShardingStrategyInitialization(Object var1);

    @Message(id=600090, value="Missing value for property '%2$s'. The sharding strategy '%1$s' requires this property to be set.")
    public SearchException missingPropertyValueForShardingStrategy(String var1, String var2);

    @Message(id=600091, value="Invalid routing key: '%1$s'. Valid keys are: %2$s.")
    public SearchException invalidRoutingKeyForExplicitShardingStrategy(String var1, Collection<String> var2);

    @Message(id=600092, value="Error fetching nested documents. Native Lucene query: '%1$s'.")
    public SearchException errorFetchingNestedDocuments(Query var1, @Cause Exception var2);

    @Message(id=600093, value="Multiple conflicting nested document paths to build a projection for field '%1$s'. '%2$s' vs. '%3$s'.")
    public SearchException conflictingNestedDocumentPathsForProjection(String var1, String var2, String var3, @Param EventContext var4);

    @Message(id=600094, value="Cannot apply an analyzer on an aggregable field. Use a normalizer instead. Analyzer: '%1$s'. If an actual analyzer (with tokenization) is necessary, define two separate fields: one with an analyzer that is not aggregable, and one with a normalizer that is aggregable.")
    public SearchException cannotUseAnalyzerOnAggregableField(String var1, @Param EventContext var2);

    @Message(id=600095, value="Aggregations are not enabled for field '%1$s'. Make sure the field is marked as aggregable.")
    public SearchException nonAggregableField(String var1, @Param EventContext var2);

    @Message(id=600096, value="Invalid type '%2$s' for aggregation on field '%1$s'.")
    public SearchException invalidAggregationInvalidType(String var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=600097, value="Multiple conflicting types to build an aggregation for field '%1$s': '%2$s' vs. '%3$s'.")
    public SearchException conflictingFieldTypesForAggregation(String var1, LuceneFieldAggregationBuilderFactory var2, LuceneFieldAggregationBuilderFactory var3, @Param EventContext var4);

    @Message(id=600098, value="An Lucene query cannot include search aggregations built using a non-Lucene search scope. Given aggregation was: '%1$s'")
    public SearchException cannotMixLuceneSearchQueryWithOtherAggregations(SearchAggregation<?> var1);

    @Message(id=600099, value="The aggregation '%1$s' is defined on a scope targeting different indexes. Aggregation is targeting: '%2$s'. Current scope is targeting: '%3$s'.")
    public SearchException aggregationDefinedOnDifferentIndexes(SearchAggregation<?> var1, Set<String> var2, Set<String> var3);

    @Message(id=600100, value="Terms aggregations are not supported by this field's type (string field with analyzed). Use a normalized field instead.")
    public SearchException termsAggregationsNotSupportedByAnalyzedTextFieldType(@Param EventContext var1);

    @Message(id=600101, value="Range aggregations are not supported by this field's type.")
    public SearchException rangeAggregationsNotSupportedByFieldType(@Param EventContext var1);

    @Message(id=600102, value="Multiple aggregations with the same key: '%1$s'")
    public SearchException duplicateAggregationKey(@FormatWith(value=AggregationKeyFormatter.class) AggregationKey var1);

    @Message(id=600103, value="This field does not support aggregations.")
    public SearchException unsupportedDSLAggregations(@Param EventContext var1);

    @Message(id=600104, value="Cannot apply a search analyzer if an analyzer has not been defined on the same field. Search analyzer: '%1$s'.")
    public SearchException searchAnalyzerWithoutAnalyzer(String var1, @Param EventContext var2);
}

