/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.reader.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.ReadIndexManagerContext;
import org.hibernate.search.backend.lucene.lowlevel.reader.spi.IndexReaderHolder;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class HolderMultiReader
extends MultiReader {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final List<IndexReaderHolder> indexReaderHolders;

    public static HolderMultiReader open(Set<String> indexNames, Set<? extends ReadIndexManagerContext> indexManagerContexts, Set<String> routingKeys) {
        if (indexManagerContexts.isEmpty()) {
            return null;
        }
        ArrayList<IndexReaderHolder> indexReaderHolders = new ArrayList<IndexReaderHolder>();
        try {
            for (ReadIndexManagerContext readIndexManagerContext : indexManagerContexts) {
                readIndexManagerContext.openIndexReaders(routingKeys, indexReaderHolders);
            }
            return new HolderMultiReader(indexReaderHolders);
        }
        catch (IOException | RuntimeException e) {
            new SuppressingCloser((Throwable)e).pushAll(indexReaderHolders);
            throw log.failureOnMultiReaderRefresh(EventContexts.fromIndexNames(indexNames), e);
        }
    }

    HolderMultiReader(List<IndexReaderHolder> indexReaderHolders) throws IOException {
        super(HolderMultiReader.toReaderArray(indexReaderHolders), true);
        this.indexReaderHolders = indexReaderHolders;
    }

    public String toString() {
        return HolderMultiReader.class.getSimpleName() + " [subReaders=" + this.getSequentialSubReaders() + ", indexReaderHolders=" + this.indexReaderHolders + "]";
    }

    protected synchronized void doClose() throws IOException {
        boolean debugEnabled = log.isDebugEnabled();
        if (debugEnabled) {
            log.debugf("Closing MultiReader: %s", (Object)this);
        }
        try (Closer closer = new Closer();){
            closer.pushAll(IndexReaderHolder::close, this.indexReaderHolders);
        }
        if (debugEnabled) {
            log.trace("MultiReader closed.");
        }
    }

    private static IndexReader[] toReaderArray(List<IndexReaderHolder> indexReaderHolders) {
        IndexReader[] indexReaders = new IndexReader[indexReaderHolders.size()];
        for (int i = 0; i < indexReaderHolders.size(); ++i) {
            indexReaders[i] = indexReaderHolders.get(i).get();
        }
        return indexReaders;
    }
}

