/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.orchestration.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.lucene.index.IndexReader;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.HolderMultiReader;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.ReadIndexManagerContext;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneReadWorkOrchestratorImplementor;
import org.hibernate.search.backend.lucene.work.impl.LuceneReadWork;
import org.hibernate.search.backend.lucene.work.impl.LuceneReadWorkExecutionContext;
import org.hibernate.search.engine.backend.orchestration.spi.AbstractWorkOrchestrator;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneReadWorkOrchestratorImpl
extends AbstractWorkOrchestrator<ReadTask<?>>
implements LuceneReadWorkOrchestratorImplementor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    public LuceneReadWorkOrchestratorImpl(String name) {
        super(name);
        this.start();
    }

    @Override
    public <T> T submit(Set<String> indexNames, Set<? extends ReadIndexManagerContext> indexManagerContexts, Set<String> routingKeys, LuceneReadWork<T> work) {
        ReadTask<T> task = new ReadTask<T>(indexNames, indexManagerContexts, routingKeys, work);
        Throwable throwable = null;
        try {
            this.submit(task);
            T t = task.getResult();
            return t;
        }
        catch (Throwable t) {
            throwable = t;
            throw t;
        }
        finally {
            if (throwable == null) {
                task.close();
            } else {
                new SuppressingCloser(throwable).push(task);
            }
        }
    }

    protected void doStart() {
    }

    protected void doSubmit(ReadTask<?> task) {
        task.execute();
    }

    protected CompletableFuture<?> getCompletion() {
        return CompletableFuture.completedFuture(null);
    }

    protected void doStop() {
    }

    static class ReadTask<T>
    implements AutoCloseable,
    LuceneReadWorkExecutionContext {
        private final Set<String> indexNames;
        private final HolderMultiReader indexReader;
        private final LuceneReadWork<T> work;
        private T result;

        ReadTask(Set<String> indexNames, Set<? extends ReadIndexManagerContext> indexManagerContexts, Set<String> routingKeys, LuceneReadWork<T> work) {
            this.indexNames = indexNames;
            this.indexReader = HolderMultiReader.open(indexNames, indexManagerContexts, routingKeys);
            this.work = work;
        }

        @Override
        public IndexReader getIndexReader() {
            return this.indexReader;
        }

        @Override
        public EventContext getEventContext() {
            return EventContexts.fromIndexNames(this.indexNames);
        }

        public void execute() {
            this.result = this.work.execute(this);
        }

        public T getResult() {
            return this.result;
        }

        @Override
        public void close() {
            try {
                this.indexReader.close();
            }
            catch (IOException | RuntimeException e) {
                log.unableToCloseIndexReader(this.getEventContext(), e);
            }
        }
    }
}

