/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.extraction.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorKey;

public class LuceneCollectors {
    private final TopDocsCollector<?> topDocsCollector;
    private final TotalHitCountCollector totalHitCountCollector;
    private final Collector compositeCollector;
    private final Collection<Collector> collectorsForNestedDocuments;
    private final Map<LuceneCollectorKey<?>, Collector> collectors;
    private final boolean requireFieldDocRescoring;
    private final Integer scoreSortFieldIndexForRescoring;
    private TopDocs topDocs = null;

    LuceneCollectors(TopDocsCollector<?> topDocsCollector, TotalHitCountCollector totalHitCountCollector, Collector compositeCollector, Collection<Collector> collectorsForNestedDocuments, Map<LuceneCollectorKey<?>, Collector> collectors, boolean requireFieldDocRescoring, Integer scoreSortFieldIndexForRescoring) {
        this.topDocsCollector = topDocsCollector;
        this.totalHitCountCollector = totalHitCountCollector;
        this.compositeCollector = compositeCollector;
        this.collectorsForNestedDocuments = collectorsForNestedDocuments;
        this.collectors = collectors;
        this.requireFieldDocRescoring = requireFieldDocRescoring;
        this.scoreSortFieldIndexForRescoring = scoreSortFieldIndexForRescoring;
    }

    public void collect(IndexSearcher indexSearcher, Query luceneQuery, int offset, Integer limit) throws IOException {
        indexSearcher.search(luceneQuery, this.compositeCollector);
        if (this.topDocsCollector == null) {
            return;
        }
        this.extractTopDocs(offset, limit);
        if (this.requireFieldDocRescoring) {
            this.handleRescoring(indexSearcher, luceneQuery);
        }
    }

    private void extractTopDocs(int offset, Integer limit) {
        this.topDocs = limit == null ? this.topDocsCollector.topDocs(offset) : this.topDocsCollector.topDocs(offset, limit.intValue());
    }

    private void handleRescoring(IndexSearcher indexSearcher, Query luceneQuery) throws IOException {
        if (this.scoreSortFieldIndexForRescoring != null) {
            for (ScoreDoc scoreDoc : this.topDocs.scoreDocs) {
                FieldDoc fieldDoc = (FieldDoc)scoreDoc;
                fieldDoc.score = ((Float)fieldDoc.fields[this.scoreSortFieldIndexForRescoring]).floatValue();
            }
        } else {
            TopFieldCollector.populateScores((ScoreDoc[])this.topDocs.scoreDocs, (IndexSearcher)indexSearcher, (Query)luceneQuery);
        }
    }

    public Collection<Collector> getCollectorsForNestedDocuments() {
        return this.collectorsForNestedDocuments;
    }

    public Map<LuceneCollectorKey<?>, Collector> getCollectors() {
        return this.collectors;
    }

    public long getTotalHits() {
        return this.totalHitCountCollector.getTotalHits();
    }

    public TopDocs getTopDocs() {
        return this.topDocs;
    }
}

