/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.impl;

import java.util.Set;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.QueryBitSetProducer;
import org.apache.lucene.search.join.ToChildBlockJoinQuery;
import org.hibernate.search.backend.lucene.search.impl.LuceneQueries;

public class LuceneNestedQueries {
    private LuceneNestedQueries() {
    }

    public static BooleanQuery findChildQuery(Set<String> nestedDocumentPaths, Query originalParentQuery) {
        QueryBitSetProducer parentsFilter = new QueryBitSetProducer(LuceneQueries.mainDocumentQuery());
        ToChildBlockJoinQuery parentQuery = new ToChildBlockJoinQuery(originalParentQuery, (BitSetProducer)parentsFilter);
        return new BooleanQuery.Builder().add((Query)parentQuery, BooleanClause.Occur.MUST).add((Query)LuceneNestedQueries.createNestedDocumentPathSubQuery(nestedDocumentPaths), BooleanClause.Occur.FILTER).add(LuceneQueries.childDocumentQuery(), BooleanClause.Occur.FILTER).build();
    }

    private static BooleanQuery createNestedDocumentPathSubQuery(Set<String> nestedDocumentPaths) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (String nestedDocumentPath : nestedDocumentPaths) {
            builder.add(LuceneQueries.nestedDocumentPathQuery(nestedDocumentPath), BooleanClause.Occur.SHOULD);
        }
        builder.setMinimumNumberShouldMatch(1);
        return builder.build();
    }
}

