/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.QueryBitSetProducer;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.search.join.ToParentBlockJoinQuery;
import org.hibernate.search.backend.lucene.search.impl.LuceneQueries;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateContext;
import org.hibernate.search.engine.search.predicate.spi.NestedPredicateBuilder;

class LuceneNestedPredicateBuilder
extends AbstractLuceneSearchPredicateBuilder
implements NestedPredicateBuilder<LuceneSearchPredicateBuilder> {
    private final String absoluteFieldPath;
    private LuceneSearchPredicateBuilder nestedBuilder;

    LuceneNestedPredicateBuilder(String absoluteFieldPath) {
        this.absoluteFieldPath = absoluteFieldPath;
    }

    public void nested(LuceneSearchPredicateBuilder nestedBuilder) {
        this.nestedBuilder = nestedBuilder;
    }

    @Override
    protected Query doBuild(LuceneSearchPredicateContext context) {
        LuceneSearchPredicateContext childContext = new LuceneSearchPredicateContext(this.absoluteFieldPath);
        BooleanQuery.Builder childQueryBuilder = new BooleanQuery.Builder();
        childQueryBuilder.add(LuceneQueries.childDocumentQuery(), BooleanClause.Occur.FILTER);
        childQueryBuilder.add(LuceneQueries.nestedDocumentPathQuery(this.absoluteFieldPath), BooleanClause.Occur.FILTER);
        childQueryBuilder.add(this.nestedBuilder.build(childContext), BooleanClause.Occur.MUST);
        Query parentQuery = context.getNestedPath() == null ? LuceneQueries.mainDocumentQuery() : LuceneQueries.nestedDocumentPathQuery(context.getNestedPath());
        return new ToParentBlockJoinQuery((Query)childQueryBuilder.build(), (BitSetProducer)new QueryBitSetProducer(parentQuery), ScoreMode.Avg);
    }
}

