/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.util.Arrays;
import java.util.Set;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorsBuilder;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneDocumentStoredFieldVisitorBuilder;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;

abstract class AbstractLuceneCompositeProjection<P>
implements LuceneSearchProjection<Object[], P> {
    private final Set<String> indexNames;
    private final LuceneSearchProjection<?, ?>[] children;

    AbstractLuceneCompositeProjection(Set<String> indexNames, LuceneSearchProjection<?, ?> ... children) {
        this.indexNames = indexNames;
        this.children = children;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[children=" + Arrays.toString(this.children) + "]";
    }

    @Override
    public final void contributeCollectors(LuceneCollectorsBuilder luceneCollectorBuilder) {
        for (LuceneSearchProjection<?, ?> child : this.children) {
            child.contributeCollectors(luceneCollectorBuilder);
        }
    }

    @Override
    public final void contributeFields(LuceneDocumentStoredFieldVisitorBuilder builder) {
        for (LuceneSearchProjection<?, ?> child : this.children) {
            child.contributeFields(builder);
        }
    }

    @Override
    public final Object[] extract(ProjectionHitMapper<?, ?> mapper, LuceneResult documentResult, SearchProjectionExtractContext context) {
        Object[] extractedData = new Object[this.children.length];
        for (int i = 0; i < extractedData.length; ++i) {
            LuceneSearchProjection<?, ?> child = this.children[i];
            extractedData[i] = child.extract(mapper, documentResult, context);
        }
        return extractedData;
    }

    @Override
    public final P transform(LoadingResult<?> loadingResult, Object[] extractedData, SearchProjectionTransformContext context) {
        for (int i = 0; i < extractedData.length; ++i) {
            LuceneSearchProjection<?, ?> child = this.children[i];
            Object extractedElement = extractedData[i];
            extractedData[i] = LuceneSearchProjection.transformUnsafe(child, loadingResult, extractedElement, context);
        }
        return this.doTransform(extractedData);
    }

    @Override
    public Set<String> getIndexNames() {
        return this.indexNames;
    }

    abstract P doTransform(Object[] var1);
}

