/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.util.Set;
import org.hibernate.search.backend.lucene.search.extraction.impl.DocumentReferenceExtractorHelper;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorsBuilder;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneDocumentStoredFieldVisitorBuilder;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;

public class LuceneEntityProjection<E>
implements LuceneSearchProjection<Object, E> {
    private final Set<String> indexNames;

    public LuceneEntityProjection(Set<String> indexNames) {
        this.indexNames = indexNames;
    }

    @Override
    public void contributeCollectors(LuceneCollectorsBuilder luceneCollectorBuilder) {
        DocumentReferenceExtractorHelper.contributeCollectors(luceneCollectorBuilder);
    }

    @Override
    public void contributeFields(LuceneDocumentStoredFieldVisitorBuilder builder) {
        DocumentReferenceExtractorHelper.contributeFields(builder);
    }

    @Override
    public Object extract(ProjectionHitMapper<?, ?> mapper, LuceneResult documentResult, SearchProjectionExtractContext context) {
        return mapper.planLoading(DocumentReferenceExtractorHelper.extractDocumentReference(documentResult));
    }

    @Override
    public E transform(LoadingResult<?> loadingResult, Object extractedData, SearchProjectionTransformContext context) {
        Object loaded = loadingResult.getLoaded(extractedData);
        if (loaded == null) {
            context.reportFailedLoad();
        }
        return (E)loaded;
    }

    @Override
    public Set<String> getIndexNames() {
        return this.indexNames;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

