/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorExtractContext;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorKey;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class SearchProjectionExtractContext
implements LuceneCollectorExtractContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexSearcher indexSearcher;
    private final Query luceneQuery;
    private final Map<Integer, Set<Integer>> nestedDocs;
    private final Map<LuceneCollectorKey<?>, Collector> collectors;

    public SearchProjectionExtractContext(IndexSearcher indexSearcher, Query luceneQuery, Map<Integer, Set<Integer>> nestedDocs, Map<LuceneCollectorKey<?>, Collector> collectors) {
        this.indexSearcher = indexSearcher;
        this.luceneQuery = luceneQuery;
        this.nestedDocs = nestedDocs;
        this.collectors = collectors;
    }

    public Explanation explain(int docId) {
        try {
            return this.indexSearcher.explain(this.luceneQuery, docId);
        }
        catch (IOException e) {
            throw log.ioExceptionOnExplain(e);
        }
    }

    @Override
    public Set<Integer> getNestedDocs(int docId) {
        return this.nestedDocs.get(docId);
    }

    public <C extends Collector> C getCollector(LuceneCollectorKey<C> key) {
        return (C)this.collectors.get(key);
    }
}

