/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneReadWorkOrchestrator;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.search.extraction.impl.ReusableDocumentStoredFieldVisitor;
import org.hibernate.search.backend.lucene.search.impl.LuceneQueries;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchQueryElementCollector;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchQuery;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryImpl;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryRequestContext;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearcherImpl;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneFieldComparatorSource;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneSearchQueryBuilder<H>
implements SearchQueryBuilder<H, LuceneSearchQueryElementCollector>,
LuceneSearchQueryElementCollector {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneWorkFactory workFactory;
    private final LuceneReadWorkOrchestrator queryOrchestrator;
    private final LuceneSearchContext searchContext;
    private final BackendSessionContext sessionContext;
    private final Set<String> routingKeys;
    private final ReusableDocumentStoredFieldVisitor storedFieldVisitor;
    private final LoadingContextBuilder<?, ?> loadingContextBuilder;
    private final LuceneSearchProjection<?, H> rootProjection;
    private List<LuceneFieldComparatorSource> nestedFieldSorts;
    private Query luceneQuery;
    private List<SortField> sortFields;
    private Map<AggregationKey<?>, LuceneSearchAggregation<?>> aggregations;

    public LuceneSearchQueryBuilder(LuceneWorkFactory workFactory, LuceneReadWorkOrchestrator queryOrchestrator, LuceneSearchContext searchContext, BackendSessionContext sessionContext, ReusableDocumentStoredFieldVisitor storedFieldVisitor, LoadingContextBuilder<?, ?> loadingContextBuilder, LuceneSearchProjection<?, H> rootProjection) {
        this.workFactory = workFactory;
        this.queryOrchestrator = queryOrchestrator;
        this.searchContext = searchContext;
        this.sessionContext = sessionContext;
        this.routingKeys = new HashSet<String>();
        this.storedFieldVisitor = storedFieldVisitor;
        this.loadingContextBuilder = loadingContextBuilder;
        this.rootProjection = rootProjection;
    }

    public LuceneSearchQueryElementCollector toQueryElementCollector() {
        return this;
    }

    public void addRoutingKey(String routingKey) {
        this.routingKeys.add(routingKey);
    }

    @Override
    public void collectPredicate(Query luceneQuery) {
        this.luceneQuery = luceneQuery;
    }

    @Override
    public void collectSortField(SortField sortField) {
        if (this.sortFields == null) {
            this.sortFields = new ArrayList<SortField>(5);
        }
        this.sortFields.add(sortField);
    }

    @Override
    public void collectSortField(SortField sortField, LuceneFieldComparatorSource nestedFieldSort) {
        this.collectSortField(sortField);
        if (nestedFieldSort == null) {
            return;
        }
        if (this.nestedFieldSorts == null) {
            this.nestedFieldSorts = new ArrayList<LuceneFieldComparatorSource>(5);
        }
        this.nestedFieldSorts.add(nestedFieldSort);
    }

    @Override
    public void collectSortFields(SortField[] sortFields) {
        if (sortFields == null || sortFields.length == 0) {
            return;
        }
        if (this.sortFields == null) {
            this.sortFields = new ArrayList<SortField>(sortFields.length);
        }
        Collections.addAll(this.sortFields, sortFields);
    }

    @Override
    public <A> void collectAggregation(AggregationKey<A> key, LuceneSearchAggregation<A> aggregation) {
        LuceneSearchAggregation<A> previous;
        if (this.aggregations == null) {
            this.aggregations = new LinkedHashMap();
        }
        if ((previous = this.aggregations.put(key, aggregation)) != null) {
            throw log.duplicateAggregationKey(key);
        }
    }

    public LuceneSearchQuery<H> build() {
        LoadingContext loadingContext = this.loadingContextBuilder.build();
        BooleanQuery.Builder luceneQueryBuilder = new BooleanQuery.Builder();
        luceneQueryBuilder.add(this.luceneQuery, BooleanClause.Occur.MUST);
        luceneQueryBuilder.add(LuceneQueries.mainDocumentQuery(), BooleanClause.Occur.FILTER);
        Sort luceneSort = null;
        if (this.sortFields != null && !this.sortFields.isEmpty()) {
            luceneSort = new Sort(this.sortFields.toArray(new SortField[0]));
        }
        Query definitiveLuceneQuery = this.searchContext.decorateLuceneQuery((Query)luceneQueryBuilder.build(), this.sessionContext.getTenantIdentifier());
        if (this.nestedFieldSorts != null) {
            for (LuceneFieldComparatorSource nestedField : this.nestedFieldSorts) {
                nestedField.setOriginalParentQuery(definitiveLuceneQuery);
            }
        }
        LuceneSearchQueryRequestContext requestContext = new LuceneSearchQueryRequestContext(this.sessionContext, loadingContext, definitiveLuceneQuery, luceneSort);
        LuceneSearcherImpl<H> searcher = new LuceneSearcherImpl<H>(requestContext, this.storedFieldVisitor, this.rootProjection, this.aggregations == null ? Collections.emptyMap() : this.aggregations);
        return new LuceneSearchQueryImpl(this.queryOrchestrator, this.workFactory, this.searchContext, this.sessionContext, loadingContext, this.routingKeys, definitiveLuceneQuery, luceneSort, searcher);
    }
}

