/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectors;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectorsBuilder;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.extraction.impl.ReusableDocumentStoredFieldVisitor;
import org.hibernate.search.backend.lucene.search.impl.LuceneNestedQueries;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneChildrenCollector;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneLoadableSearchResult;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryExtractContext;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryRequestContext;
import org.hibernate.search.backend.lucene.util.impl.LuceneFields;
import org.hibernate.search.backend.lucene.work.impl.LuceneSearcher;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class LuceneSearcherImpl<H>
implements LuceneSearcher<LuceneLoadableSearchResult<H>> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final Set<String> ID_FIELD_SET = Collections.singleton(LuceneFields.idFieldName());
    private final LuceneSearchQueryRequestContext requestContext;
    private final ReusableDocumentStoredFieldVisitor storedFieldVisitor;
    private final LuceneSearchProjection<?, H> rootProjection;
    private final Map<AggregationKey<?>, LuceneSearchAggregation<?>> aggregations;

    LuceneSearcherImpl(LuceneSearchQueryRequestContext requestContext, ReusableDocumentStoredFieldVisitor storedFieldVisitor, LuceneSearchProjection<?, H> rootProjection, Map<AggregationKey<?>, LuceneSearchAggregation<?>> aggregations) {
        this.requestContext = requestContext;
        this.storedFieldVisitor = storedFieldVisitor;
        this.rootProjection = rootProjection;
        this.aggregations = aggregations;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("luceneQuery=").append(this.requestContext.getLuceneQuery()).append(", luceneSort=").append(this.requestContext.getLuceneSort()).append("]");
        return sb.toString();
    }

    @Override
    public LuceneLoadableSearchResult<H> search(IndexSearcher indexSearcher, int offset, Integer limit) throws IOException {
        LuceneCollectors luceneCollectors = this.buildCollectors(indexSearcher, offset, limit);
        luceneCollectors.collect(indexSearcher, this.requestContext.getLuceneQuery(), offset, limit);
        LuceneSearchQueryExtractContext extractContext = this.requestContext.createExtractContext(indexSearcher, luceneCollectors);
        List<Object> extractedData = this.extractHits(extractContext);
        Map extractedAggregations = this.aggregations.isEmpty() ? Collections.emptyMap() : this.extractAggregations(extractContext);
        return new LuceneLoadableSearchResult<H>(extractContext, this.rootProjection, luceneCollectors.getTotalHits(), extractedData, extractedAggregations);
    }

    @Override
    public int count(IndexSearcher indexSearcher) throws IOException {
        return indexSearcher.count(this.requestContext.getLuceneQuery());
    }

    @Override
    public Explanation explain(IndexSearcher indexSearcher, int luceneDocId) throws IOException {
        return indexSearcher.explain(this.requestContext.getLuceneQuery(), luceneDocId);
    }

    @Override
    public Query getLuceneQueryForExceptions() {
        return this.requestContext.getLuceneQuery();
    }

    private LuceneCollectors buildCollectors(IndexSearcher indexSearcher, int offset, Integer limit) {
        int maxDocs = this.getMaxDocs(indexSearcher.getIndexReader(), offset, limit);
        LuceneCollectorsBuilder luceneCollectorsBuilder = new LuceneCollectorsBuilder(this.requestContext.getLuceneSort(), maxDocs);
        this.rootProjection.contributeCollectors(luceneCollectorsBuilder);
        for (LuceneSearchAggregation<?> aggregation : this.aggregations.values()) {
            aggregation.contributeCollectors(luceneCollectorsBuilder);
        }
        return luceneCollectorsBuilder.build();
    }

    private int getMaxDocs(IndexReader reader, int offset, Integer limit) {
        if (limit == null) {
            return reader.maxDoc();
        }
        if (limit.equals(0)) {
            return 0;
        }
        return Math.min(offset + limit, reader.maxDoc());
    }

    private List<Object> extractHits(LuceneSearchQueryExtractContext extractContext) throws IOException {
        ProjectionHitMapper<?, ?> projectionHitMapper = extractContext.getProjectionHitMapper();
        IndexSearcher indexSearcher = extractContext.getIndexSearcher();
        TopDocs topDocs = extractContext.getTopDocs();
        if (topDocs == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> extractedData = new ArrayList<Object>(topDocs.scoreDocs.length);
        Map<Integer, Set<Integer>> nestedDocs = this.fetchNestedDocs(indexSearcher, topDocs.scoreDocs, extractContext);
        SearchProjectionExtractContext projectionExtractContext = extractContext.createProjectionExtractContext(nestedDocs);
        for (ScoreDoc hit : topDocs.scoreDocs) {
            indexSearcher.doc(hit.doc, (StoredFieldVisitor)this.storedFieldVisitor);
            if (nestedDocs.containsKey(hit.doc)) {
                for (Integer child : nestedDocs.get(hit.doc)) {
                    indexSearcher.doc(child.intValue(), (StoredFieldVisitor)this.storedFieldVisitor);
                }
            }
            Document document = this.storedFieldVisitor.getDocumentAndReset();
            LuceneResult luceneResult = new LuceneResult(document, hit.doc, hit.score);
            extractedData.add(this.rootProjection.extract(projectionHitMapper, luceneResult, projectionExtractContext));
        }
        return extractedData;
    }

    private Map<AggregationKey<?>, ?> extractAggregations(LuceneSearchQueryExtractContext extractContext) throws IOException {
        AggregationExtractContext aggregationExtractContext = extractContext.createAggregationExtractContext();
        LinkedHashMap extractedMap = new LinkedHashMap();
        for (Map.Entry<AggregationKey<?>, LuceneSearchAggregation<?>> entry : this.aggregations.entrySet()) {
            AggregationKey<?> key = entry.getKey();
            LuceneSearchAggregation<?> aggregation = entry.getValue();
            Object extracted = aggregation.extract(aggregationExtractContext);
            extractedMap.put(key, extracted);
        }
        return extractedMap;
    }

    private Map<Integer, Set<Integer>> fetchNestedDocs(IndexSearcher indexSearcher, ScoreDoc[] scoreDocs, LuceneSearchQueryExtractContext extractContext) throws IOException {
        if (this.storedFieldVisitor.getNestedDocumentPaths().isEmpty()) {
            return new HashMap<Integer, Set<Integer>>();
        }
        HashMap<String, Integer> parentIds = new HashMap<String, Integer>();
        for (ScoreDoc hit : scoreDocs) {
            Document doc = indexSearcher.doc(hit.doc, ID_FIELD_SET);
            String parentId = doc.getField(LuceneFields.idFieldName()).stringValue();
            if (parentId == null) continue;
            parentIds.put(parentId, hit.doc);
        }
        Map<String, Set<Integer>> stringSetMap = this.fetchChildren(indexSearcher, this.storedFieldVisitor.getNestedDocumentPaths(), extractContext.getCollectorsForNestedDocuments());
        HashMap<Integer, Set<Integer>> result = new HashMap<Integer, Set<Integer>>();
        for (Map.Entry<String, Set<Integer>> entry : stringSetMap.entrySet()) {
            result.put((Integer)parentIds.get(entry.getKey()), entry.getValue());
        }
        return result;
    }

    private Map<String, Set<Integer>> fetchChildren(IndexSearcher indexSearcher, Set<String> nestedDocumentPaths, Collection<Collector> collectorsForChildren) {
        BooleanQuery booleanQuery = LuceneNestedQueries.findChildQuery(nestedDocumentPaths, this.requestContext.getLuceneQuery());
        try {
            ArrayList<Collector> luceneCollectors = new ArrayList<Collector>();
            LuceneChildrenCollector childrenCollector = new LuceneChildrenCollector();
            luceneCollectors.add(childrenCollector);
            luceneCollectors.addAll(collectorsForChildren);
            indexSearcher.search((Query)booleanQuery, MultiCollector.wrap(luceneCollectors));
            return childrenCollector.getChildren();
        }
        catch (IOException e) {
            throw log.errorFetchingNestedDocuments((Query)booleanQuery, e);
        }
    }
}

