/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.codec.impl;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.util.Locale;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentBuilder;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneOffsetDateTimeFieldCodec;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneLongDomain;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;
import org.hibernate.search.util.common.impl.TimeHelper;

public final class LuceneZonedDateTimeFieldCodec
extends AbstractLuceneNumericFieldCodec<ZonedDateTime, Long> {
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(LuceneOffsetDateTimeFieldCodec.FORMATTER).optionalStart().appendLiteral('[').parseCaseSensitive().appendZoneRegionId().appendLiteral(']').optionalEnd().toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT);

    public LuceneZonedDateTimeFieldCodec(boolean projectable, boolean searchable, boolean sortable, boolean aggregable, ZonedDateTime indexNullAsValue) {
        super(projectable, searchable, sortable, aggregable, indexNullAsValue);
    }

    @Override
    void doEncodeForProjection(LuceneDocumentBuilder documentBuilder, String absoluteFieldPath, ZonedDateTime value, Long encodedValue) {
        documentBuilder.addField((IndexableField)new StoredField(absoluteFieldPath, FORMATTER.format(value)));
    }

    @Override
    public ZonedDateTime decode(Document document, String absoluteFieldPath) {
        IndexableField field = document.getField(absoluteFieldPath);
        if (field == null) {
            return null;
        }
        String value = field.stringValue();
        if (value == null) {
            return null;
        }
        return TimeHelper.parseZoneDateTime((String)value, (DateTimeFormatter)FORMATTER);
    }

    @Override
    public Long encode(ZonedDateTime value) {
        return value == null ? null : Long.valueOf(value.toInstant().toEpochMilli());
    }

    @Override
    public ZonedDateTime decode(Long encoded) {
        return Instant.ofEpochMilli(encoded).atZone(ZoneOffset.UTC);
    }

    @Override
    public LuceneNumericDomain<Long> getDomain() {
        return LuceneLongDomain.get();
    }
}

