/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.impl;

import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaFieldNode;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaNodeCollector;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexSchemaObjectNode;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LuceneFieldAggregationBuilderFactory;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.IndexFieldType;

public class LuceneIndexFieldType<F>
implements IndexFieldType<F> {
    private final LuceneFieldCodec<F> codec;
    private final LuceneFieldPredicateBuilderFactory predicateBuilderFactory;
    private final LuceneFieldSortBuilderFactory sortBuilderFactory;
    private final LuceneFieldProjectionBuilderFactory projectionBuilderFactory;
    private final LuceneFieldAggregationBuilderFactory aggregationBuilderFactory;
    private final boolean aggregable;
    private final Analyzer analyzerOrNormalizer;

    public LuceneIndexFieldType(LuceneFieldCodec<F> codec, LuceneFieldPredicateBuilderFactory predicateBuilderFactory, LuceneFieldSortBuilderFactory sortBuilderFactory, LuceneFieldProjectionBuilderFactory projectionBuilderFactory, LuceneFieldAggregationBuilderFactory aggregationBuilderFactory, boolean aggregable) {
        this(codec, predicateBuilderFactory, sortBuilderFactory, projectionBuilderFactory, aggregationBuilderFactory, aggregable, null);
    }

    public LuceneIndexFieldType(LuceneFieldCodec<F> codec, LuceneFieldPredicateBuilderFactory predicateBuilderFactory, LuceneFieldSortBuilderFactory sortBuilderFactory, LuceneFieldProjectionBuilderFactory projectionBuilderFactory, LuceneFieldAggregationBuilderFactory aggregationBuilderFactory, boolean aggregable, Analyzer analyzerOrNormalizer) {
        this.codec = codec;
        this.predicateBuilderFactory = predicateBuilderFactory;
        this.sortBuilderFactory = sortBuilderFactory;
        this.projectionBuilderFactory = projectionBuilderFactory;
        this.aggregationBuilderFactory = aggregationBuilderFactory;
        this.aggregable = aggregable;
        this.analyzerOrNormalizer = analyzerOrNormalizer;
    }

    public LuceneIndexSchemaFieldNode<F> addField(LuceneIndexSchemaNodeCollector collector, LuceneIndexSchemaObjectNode parentNode, String relativeFieldName, boolean multiValued) {
        LuceneIndexSchemaFieldNode<F> schemaNode = new LuceneIndexSchemaFieldNode<F>(parentNode, relativeFieldName, multiValued, this.codec, this.predicateBuilderFactory, this.sortBuilderFactory, this.projectionBuilderFactory, this.aggregationBuilderFactory);
        collector.collectFieldNode(schemaNode.getAbsoluteFieldPath(), schemaNode);
        if (this.aggregable) {
            collector.collectFacetConfig(schemaNode.getAbsoluteFieldPath(), multiValued);
        }
        if (this.analyzerOrNormalizer != null) {
            collector.collectAnalyzer(schemaNode.getAbsoluteFieldPath(), this.analyzerOrNormalizer);
        }
        return schemaNode;
    }
}

