/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.lowlevel.impl;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.document.DoubleDocValuesField;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.LongValueFacetCounts;
import org.apache.lucene.facet.range.DoubleRangeFacetCounts;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BitSet;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.FacetCountsUtils;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.NestedDocsProvider;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.OnTheFlyNestedSorter;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.SortedNumericDoubleValues;
import org.hibernate.search.util.common.data.Range;

public class LuceneDoubleDomain
implements LuceneNumericDomain<Double> {
    private static final LuceneNumericDomain<Double> INSTANCE = new LuceneDoubleDomain();

    public static LuceneNumericDomain<Double> get() {
        return INSTANCE;
    }

    @Override
    public Double getMinValue() {
        return Double.MIN_VALUE;
    }

    @Override
    public Double getMaxValue() {
        return Double.MAX_VALUE;
    }

    @Override
    public Double getPreviousValue(Double value) {
        return Math.nextDown(value);
    }

    @Override
    public Double getNextValue(Double value) {
        return Math.nextUp(value);
    }

    @Override
    public Query createExactQuery(String absoluteFieldPath, Double value) {
        return DoublePoint.newExactQuery((String)absoluteFieldPath, (double)value);
    }

    @Override
    public Query createRangeQuery(String absoluteFieldPath, Double lowerLimit, Double upperLimit) {
        return DoublePoint.newRangeQuery((String)absoluteFieldPath, (double)lowerLimit, (double)upperLimit);
    }

    @Override
    public Double fromDocValue(Long longValue) {
        return Double.longBitsToDouble(longValue);
    }

    @Override
    public LongValueFacetCounts createTermsFacetCounts(String absoluteFieldPath, FacetsCollector facetsCollector) throws IOException {
        return new LongValueFacetCounts(absoluteFieldPath, LongValuesSource.fromLongField((String)absoluteFieldPath), facetsCollector);
    }

    @Override
    public Facets createRangeFacetCounts(String absoluteFieldPath, FacetsCollector facetsCollector, Collection<? extends Range<? extends Double>> ranges) throws IOException {
        return new DoubleRangeFacetCounts(absoluteFieldPath, facetsCollector, FacetCountsUtils.createDoubleRanges(ranges));
    }

    @Override
    public IndexableField createIndexField(String absoluteFieldPath, Double numericValue) {
        return new DoublePoint(absoluteFieldPath, new double[]{numericValue});
    }

    @Override
    public IndexableField createDocValuesField(String absoluteFieldPath, Double numericValue) {
        return new DoubleDocValuesField(absoluteFieldPath, numericValue.doubleValue());
    }

    @Override
    public FieldComparator.NumericComparator<Double> createFieldComparator(String fieldName, int numHits, Double missingValue, NestedDocsProvider nestedDocsProvider) {
        return new DoubleFieldComparator(numHits, fieldName, missingValue, nestedDocsProvider);
    }

    public static class DoubleFieldComparator
    extends FieldComparator.DoubleComparator {
        private NestedDocsProvider nestedDocsProvider;

        public DoubleFieldComparator(int numHits, String field, Double missingValue, NestedDocsProvider nestedDocsProvider) {
            super(numHits, field, missingValue);
            this.nestedDocsProvider = nestedDocsProvider;
        }

        protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
            NumericDocValues numericDocValues = super.getNumericDocValues(context, field);
            if (this.nestedDocsProvider == null) {
                return numericDocValues;
            }
            SortedNumericDoubleValues sortedNumericDoubleValues = SortedNumericDoubleValues.createDouble(numericDocValues);
            BitSet parentDocs = this.nestedDocsProvider.parentDocs(context);
            DocIdSetIterator childDocs = this.nestedDocsProvider.childDocs(context);
            if (parentDocs != null && childDocs != null) {
                numericDocValues = OnTheFlyNestedSorter.sort(sortedNumericDoubleValues, (Double)this.missingValue, parentDocs, childDocs).getRawDoubleValues();
            }
            return numericDocValues;
        }
    }
}

