/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.lowlevel.impl;

import java.io.IOException;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DoubleValues;

public abstract class NumericDoubleValues
extends DoubleValues {
    protected NumericDoubleValues() {
    }

    public NumericDocValues getRawDoubleValues() {
        return new NumericDocValues(){
            private int docID = -1;

            public boolean advanceExact(int target) throws IOException {
                this.docID = target;
                return NumericDoubleValues.this.advanceExact(target);
            }

            public long longValue() throws IOException {
                return Double.doubleToRawLongBits(NumericDoubleValues.this.doubleValue());
            }

            public int docID() {
                return this.docID;
            }

            public int nextDoc() {
                throw new UnsupportedOperationException();
            }

            public int advance(int target) {
                throw new UnsupportedOperationException();
            }

            public long cost() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public NumericDocValues getRawFloatValues() {
        return new NumericDocValues(){
            private int docID = -1;

            public boolean advanceExact(int target) throws IOException {
                this.docID = target;
                return NumericDoubleValues.this.advanceExact(target);
            }

            public long longValue() throws IOException {
                return Float.floatToRawIntBits((float)NumericDoubleValues.this.doubleValue());
            }

            public int docID() {
                return this.docID;
            }

            public int nextDoc() {
                throw new UnsupportedOperationException();
            }

            public int advance(int target) {
                throw new UnsupportedOperationException();
            }

            public long cost() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

