/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.lowlevel.impl;

import java.io.IOException;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.NumericDoubleValues;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.SortedNumericDoubleValues;
import org.hibernate.search.util.common.impl.Contracts;

public class OnTheFlyNestedSorter {
    private OnTheFlyNestedSorter() {
    }

    public static SortedDocValues sort(final SortedDocValues selectedValues, final BitSet parentDocs, final DocIdSetIterator childDocs) {
        Contracts.assertNotNull((Object)parentDocs, (String)"parent docs");
        Contracts.assertNotNull((Object)childDocs, (String)"child docs");
        return new SortedDocValues(){
            int docID = -1;
            int lastSeenParentDoc = 0;
            int lastEmittedOrd = -1;

            public BytesRef lookupOrd(int ord) throws IOException {
                return selectedValues.lookupOrd(ord);
            }

            public int getValueCount() {
                return selectedValues.getValueCount();
            }

            public boolean advanceExact(int parentDoc) throws IOException {
                assert (parentDoc >= this.lastSeenParentDoc) : "can only evaluate current and upcoming root docs";
                if (parentDoc == this.lastSeenParentDoc) {
                    return this.lastEmittedOrd != -1;
                }
                int prevParentDoc = parentDocs.prevSetBit(parentDoc - 1);
                int firstChildDoc = childDocs.docID() > prevParentDoc ? childDocs.docID() : childDocs.advance(prevParentDoc + 1);
                this.docID = this.lastSeenParentDoc = parentDoc;
                this.lastEmittedOrd = OnTheFlyNestedSorter.pick(selectedValues, childDocs, firstChildDoc, parentDoc, Integer.MAX_VALUE);
                return this.lastEmittedOrd != -1;
            }

            public int docID() {
                return this.docID;
            }

            public int nextDoc() {
                throw new UnsupportedOperationException();
            }

            public int advance(int target) {
                throw new UnsupportedOperationException();
            }

            public long cost() {
                throw new UnsupportedOperationException();
            }

            public int ordValue() {
                return this.lastEmittedOrd;
            }
        };
    }

    public static NumericDocValues sort(final SortedNumericDocValues values, final long missingValue, final BitSet parentDocs, final DocIdSetIterator childDocs) {
        return new NumericDocValues(){
            int lastSeenParentDoc = -1;
            long lastEmittedValue = missingValue;

            public boolean advanceExact(int parentDoc) throws IOException {
                assert (parentDoc >= this.lastSeenParentDoc) : "can only evaluate current and upcoming parent docs";
                if (parentDoc == this.lastSeenParentDoc) {
                    return true;
                }
                if (parentDoc == 0) {
                    this.lastEmittedValue = missingValue;
                    return true;
                }
                int prevParentDoc = parentDocs.prevSetBit(parentDoc - 1);
                int firstChildDoc = childDocs.docID() > prevParentDoc ? childDocs.docID() : childDocs.advance(prevParentDoc + 1);
                this.lastSeenParentDoc = parentDoc;
                this.lastEmittedValue = OnTheFlyNestedSorter.pick(values, missingValue, childDocs, firstChildDoc, parentDoc, Integer.MAX_VALUE);
                return true;
            }

            public int docID() {
                return this.lastSeenParentDoc;
            }

            public int nextDoc() {
                throw new UnsupportedOperationException();
            }

            public int advance(int target) {
                throw new UnsupportedOperationException();
            }

            public long cost() {
                throw new UnsupportedOperationException();
            }

            public long longValue() {
                return this.lastEmittedValue;
            }
        };
    }

    public static NumericDoubleValues sort(final SortedNumericDoubleValues values, final double missingValue, final BitSet parentDocs, final DocIdSetIterator childDocs) {
        return new NumericDoubleValues(){
            int lastSeenParentDoc = 0;
            double lastEmittedValue = missingValue;

            public boolean advanceExact(int parentDoc) throws IOException {
                assert (parentDoc >= this.lastSeenParentDoc) : "can only evaluate current and upcoming parent docs";
                if (parentDoc == this.lastSeenParentDoc) {
                    return true;
                }
                int prevParentDoc = parentDocs.prevSetBit(parentDoc - 1);
                int firstChildDoc = childDocs.docID() > prevParentDoc ? childDocs.docID() : childDocs.advance(prevParentDoc + 1);
                this.lastSeenParentDoc = parentDoc;
                this.lastEmittedValue = OnTheFlyNestedSorter.pick(values, missingValue, childDocs, firstChildDoc, parentDoc, Integer.MAX_VALUE);
                return true;
            }

            public double doubleValue() {
                return this.lastEmittedValue;
            }
        };
    }

    protected static int pick(SortedDocValues values, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
        int ord = Integer.MAX_VALUE;
        boolean hasValue = false;
        int count = 0;
        int doc = startDoc;
        while (doc < endDoc) {
            if (values.advanceExact(doc)) {
                if (++count > maxChildren) break;
                int innerOrd = values.ordValue();
                ord = Math.min(ord, innerOrd);
                hasValue = true;
            }
            doc = docItr.nextDoc();
        }
        return hasValue ? ord : -1;
    }

    protected static long pick(SortedNumericDocValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
        boolean hasValue = false;
        long minValue = Long.MAX_VALUE;
        int count = 0;
        int doc = startDoc;
        while (doc < endDoc) {
            if (values.advanceExact(doc)) {
                if (++count > maxChildren) break;
                minValue = Math.min(minValue, values.nextValue());
                hasValue = true;
            }
            doc = docItr.nextDoc();
        }
        return hasValue ? minValue : missingValue;
    }

    protected static double pick(SortedNumericDoubleValues values, double missingValue, DocIdSetIterator docItr, int startDoc, int endDoc, int maxChildren) throws IOException {
        boolean hasValue = false;
        double minValue = Double.POSITIVE_INFINITY;
        int count = 0;
        int doc = startDoc;
        while (doc < endDoc) {
            if (values.advanceExact(doc)) {
                if (++count > maxChildren) break;
                minValue = Math.min(minValue, values.nextValue());
                hasValue = true;
            }
            doc = docItr.nextDoc();
        }
        return hasValue ? minValue : missingValue;
    }
}

